/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.mapping.DefaultMappingEntry;
import org.onosproject.mapping.Mapping;
import org.onosproject.mapping.MappingEntry;
import org.onosproject.mapping.MappingEvent;
import org.onosproject.mapping.MappingId;
import org.onosproject.mapping.MappingStore;
import org.onosproject.mapping.MappingStoreDelegate;
import org.onosproject.mapping.StoredMappingEntry;
import org.onosproject.net.DeviceId;
import org.onosproject.store.AbstractStore;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleMappingStore
extends AbstractStore<MappingEvent, MappingStoreDelegate>
implements MappingStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String UNRECOGNIZED_STORE_MSG = "Unrecognized store type {}";
    private final ConcurrentMap<DeviceId, ConcurrentMap<MappingId, List<StoredMappingEntry>>> mapDbStore = Maps.newConcurrentMap();
    private final ConcurrentMap<DeviceId, ConcurrentMap<MappingId, List<StoredMappingEntry>>> mapCacheStore = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.mapDbStore.clear();
        this.mapCacheStore.clear();
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
    }

    public int getMappingCount(MappingStore.Type type) {
        int sum = 0;
        for (ConcurrentMap mapDb : this.getMappingStore(type).values()) {
            for (List mes : mapDb.values()) {
                sum += mes.size();
            }
        }
        return sum;
    }

    public Iterable<MappingEntry> getAllMappingEntries(MappingStore.Type type) {
        ArrayList entries = Lists.newArrayList();
        for (ConcurrentMap mapDb : this.getMappingStore(type).values()) {
            for (List mes : mapDb.values()) {
                entries.addAll(mes);
            }
        }
        return entries;
    }

    private ConcurrentMap<MappingId, List<StoredMappingEntry>> getMappingStoreByDeviceId(MappingStore.Type type, DeviceId deviceId) {
        switch (type) {
            case MAP_DATABASE: {
                return this.mapDbStore.computeIfAbsent(deviceId, k -> Maps.newConcurrentMap());
            }
            case MAP_CACHE: {
                return this.mapCacheStore.computeIfAbsent(deviceId, k -> Maps.newConcurrentMap());
            }
        }
        this.log.error(UNRECOGNIZED_STORE_MSG, (Object)type);
        return null;
    }

    private ConcurrentMap<DeviceId, ConcurrentMap<MappingId, List<StoredMappingEntry>>> getMappingStore(MappingStore.Type type) {
        switch (type) {
            case MAP_DATABASE: {
                return this.mapDbStore;
            }
            case MAP_CACHE: {
                return this.mapCacheStore;
            }
        }
        this.log.error(UNRECOGNIZED_STORE_MSG, (Object)type);
        return null;
    }

    private List<StoredMappingEntry> getMappingEntriesInternal(MappingStore.Type type, DeviceId deviceId, MappingId mappingId) {
        List concurrentlyAdded;
        ConcurrentMap<MappingId, List<StoredMappingEntry>> store = this.getMappingStoreByDeviceId(type, deviceId);
        CopyOnWriteArrayList r = (CopyOnWriteArrayList)store.get(mappingId);
        if (r == null && (concurrentlyAdded = (List)store.putIfAbsent(mappingId, r = new CopyOnWriteArrayList())) != null) {
            return concurrentlyAdded;
        }
        return r;
    }

    private MappingEntry getMappingEntryInternal(MappingStore.Type type, DeviceId deviceId, Mapping mapping) {
        List<StoredMappingEntry> mes = this.getMappingEntriesInternal(type, deviceId, mapping.id());
        for (StoredMappingEntry me : mes) {
            if (!me.equals(mapping)) continue;
            return me;
        }
        return null;
    }

    public MappingEntry getMappingEntry(MappingStore.Type type, Mapping mapping) {
        return this.getMappingEntryInternal(type, mapping.deviceId(), mapping);
    }

    public Iterable<MappingEntry> getMappingEntries(MappingStore.Type type, DeviceId deviceId) {
        return FluentIterable.from(this.getMappingStoreByDeviceId(type, deviceId).values()).transformAndConcat(Collections::unmodifiableList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMapping(MappingStore.Type type, MappingEntry mapping) {
        List<StoredMappingEntry> entries;
        List<StoredMappingEntry> list = entries = this.getMappingEntriesInternal(type, mapping.deviceId(), mapping.id());
        synchronized (list) {
            if (!entries.contains(mapping)) {
                DefaultMappingEntry entry = new DefaultMappingEntry((Mapping)mapping, mapping.state());
                entries.add((StoredMappingEntry)entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pendingDeleteMapping(MappingStore.Type type, Mapping mapping) {
        List<StoredMappingEntry> entries;
        List<StoredMappingEntry> list = entries = this.getMappingEntriesInternal(type, mapping.deviceId(), mapping.id());
        synchronized (list) {
            for (StoredMappingEntry entry : entries) {
                if (!entry.equals(mapping)) continue;
                StoredMappingEntry storedMappingEntry = entry;
                synchronized (storedMappingEntry) {
                    entry.setState(MappingEntry.MappingEntryState.PENDING_REMOVE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingEvent addOrUpdateMappingEntry(MappingStore.Type type, MappingEntry entry) {
        List<StoredMappingEntry> entries;
        List<StoredMappingEntry> list = entries = this.getMappingEntriesInternal(type, entry.deviceId(), entry.id());
        synchronized (list) {
            for (StoredMappingEntry stored : entries) {
                if (!stored.equals(entry)) continue;
                if (stored.state() == MappingEntry.MappingEntryState.PENDING_ADD) {
                    stored.setState(MappingEntry.MappingEntryState.ADDED);
                    return new MappingEvent(MappingEvent.Type.MAPPING_ADDED, (Mapping)entry);
                }
                return new MappingEvent(MappingEvent.Type.MAPPING_UPDATED, (Mapping)entry);
            }
        }
        this.log.error("Mapping was not found in store {} to update", (Object)entry);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingEvent removeMapping(MappingStore.Type type, Mapping mapping) {
        List<StoredMappingEntry> entries;
        List<StoredMappingEntry> list = entries = this.getMappingEntriesInternal(type, mapping.deviceId(), mapping.id());
        synchronized (list) {
            if (entries.remove(mapping)) {
                return new MappingEvent(MappingEvent.Type.MAPPING_REMOVED, mapping);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingEvent pendingMappingEntry(MappingStore.Type type, MappingEntry entry) {
        List<StoredMappingEntry> entries;
        List<StoredMappingEntry> list = entries = this.getMappingEntriesInternal(type, entry.deviceId(), entry.id());
        synchronized (list) {
            for (StoredMappingEntry stored : entries) {
                if (!stored.equals(entry) || stored.state() == MappingEntry.MappingEntryState.PENDING_ADD) continue;
                StoredMappingEntry storedMappingEntry = stored;
                synchronized (storedMappingEntry) {
                    stored.setState(MappingEntry.MappingEntryState.PENDING_ADD);
                    return new MappingEvent(MappingEvent.Type.MAPPING_UPDATED, (Mapping)entry);
                }
            }
        }
        return null;
    }

    public void purgeMappingEntry(MappingStore.Type type, DeviceId deviceId) {
        this.getMappingStore(type).remove(deviceId);
    }

    public void purgeMappingEntries(MappingStore.Type type) {
        this.getMappingStore(type).clear();
    }
}

