/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.mapping.Mapping;
import org.onosproject.mapping.MappingAdminService;
import org.onosproject.mapping.MappingEntry;
import org.onosproject.mapping.MappingEvent;
import org.onosproject.mapping.MappingKey;
import org.onosproject.mapping.MappingListener;
import org.onosproject.mapping.MappingProvider;
import org.onosproject.mapping.MappingProviderRegistry;
import org.onosproject.mapping.MappingProviderService;
import org.onosproject.mapping.MappingService;
import org.onosproject.mapping.MappingStore;
import org.onosproject.mapping.MappingStoreDelegate;
import org.onosproject.mapping.MappingValue;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class MappingManager
extends AbstractListenerProviderRegistry<MappingEvent, MappingListener, MappingProvider, MappingProviderService>
implements MappingService,
MappingAdminService,
MappingProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String MAPPING_OP_TOPIC = "mapping-ops-ids";
    private final MappingStoreDelegate delegate = new InternalStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MappingStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(MappingEvent.class, (EventSink)this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(MappingEvent.class);
        this.log.info("Stopped");
    }

    public int getMappingCount(MappingStore.Type type) {
        return this.store.getMappingCount(type);
    }

    public Iterable<MappingEntry> getAllMappingEntries(MappingStore.Type type) {
        return this.store.getAllMappingEntries(type);
    }

    public void storeMappingEntry(MappingStore.Type type, MappingEntry entry) {
        this.store.storeMapping(type, entry);
    }

    public Iterable<MappingEntry> getMappingEntries(MappingStore.Type type, DeviceId deviceId) {
        return this.store.getMappingEntries(type, deviceId);
    }

    public Iterable<MappingEntry> getMappingEntriesByAppId(MappingStore.Type type, ApplicationId appId) {
        HashSet mappingEntries = Sets.newHashSet();
        for (Device d : this.deviceService.getDevices()) {
            for (MappingEntry mappingEntry : this.store.getMappingEntries(type, d.id())) {
                if (mappingEntry.appId() != appId.id()) continue;
                mappingEntries.add(mappingEntry);
            }
        }
        return mappingEntries;
    }

    public void removeMappingEntries(MappingStore.Type type, MappingEntry ... mappingEntries) {
        for (MappingEntry entry : mappingEntries) {
            this.store.removeMapping(type, (Mapping)entry);
        }
    }

    public void removeMappingEntriesByAppId(MappingStore.Type type, ApplicationId appId) {
        this.removeMappingEntries(type, (MappingEntry[])Iterables.toArray(this.getMappingEntriesByAppId(type, appId), MappingEntry.class));
    }

    public void purgeMappings(MappingStore.Type type, DeviceId deviceId) {
        this.store.purgeMappingEntry(type, deviceId);
    }

    protected MappingProviderService createProviderService(MappingProvider provider) {
        return new InternalMappingProviderService(provider);
    }

    private MappingValue getMappingValueByMappingKey(MappingKey mappingKey) {
        for (MappingEntry entry : this.store.getAllMappingEntries(MappingStore.Type.MAP_DATABASE)) {
            if (!entry.key().equals(mappingKey)) continue;
            return entry.value();
        }
        return null;
    }

    protected void bindStore(MappingStore mappingStore) {
        this.store = mappingStore;
    }

    protected void unbindStore(MappingStore mappingStore) {
        if (this.store == mappingStore) {
            this.store = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    private class InternalMappingProviderService
    extends AbstractProviderService<MappingProvider>
    implements MappingProviderService {
        protected InternalMappingProviderService(MappingProvider provider) {
            super((Provider)provider);
        }

        public void mappingAdded(MappingEntry mappingEntry, MappingStore.Type type) {
            MappingManager.this.storeMappingEntry(type, mappingEntry);
        }

        public MappingValue mappingQueried(MappingKey mappingKey) {
            return MappingManager.this.getMappingValueByMappingKey(mappingKey);
        }

        public List<MappingValue> mappingQueried(List<MappingKey> mappingKeys) {
            ArrayList values = Lists.newArrayList();
            mappingKeys.forEach(key -> {
                MappingValue value = MappingManager.this.getMappingValueByMappingKey(key);
                if (value != null) {
                    values.add(value);
                }
            });
            return ImmutableList.copyOf((Collection)values);
        }
    }

    private class InternalStoreDelegate
    implements MappingStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(MappingEvent event) {
            MappingManager.this.post((Event)event);
        }
    }
}

