/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.mapping.DefaultMapping;
import org.onosproject.mapping.DefaultMappingEntry;
import org.onosproject.mapping.Mapping;
import org.onosproject.mapping.MappingEntry;
import org.onosproject.mapping.MappingEvent;
import org.onosproject.mapping.MappingId;
import org.onosproject.mapping.MappingKey;
import org.onosproject.mapping.MappingStore;
import org.onosproject.mapping.MappingStoreDelegate;
import org.onosproject.mapping.MappingTreatment;
import org.onosproject.mapping.MappingValue;
import org.onosproject.mapping.actions.MappingAction;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.mapping.instructions.MappingInstruction;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedMappingStore
extends AbstractStore<MappingEvent, MappingStoreDelegate>
implements MappingStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ConsistentMap<MappingId, Mapping> database;
    private ConsistentMap<MappingId, Mapping> cache;
    private Map<MappingId, Mapping> databaseMap;
    private Map<MappingId, Mapping> cacheMap;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private final MapEventListener<MappingId, Mapping> listener = new InternalListener();

    @Activate
    public void activate() {
        Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.API, (Class[])new Class[]{Mapping.class, DefaultMapping.class, MappingId.class, MappingEvent.Type.class, MappingKey.class, MappingValue.class, MappingAddress.class, MappingAddress.Type.class, MappingAction.class, MappingAction.Type.class, MappingTreatment.class, MappingInstruction.class, MappingInstruction.Type.class});
        this.database = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-mapping-database")).withSerializer(serializer)).build();
        this.cache = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-mapping-cache")).withSerializer(serializer)).build();
        this.database.addListener(this.listener);
        this.cache.addListener(this.listener);
        this.databaseMap = this.database.asJavaMap();
        this.cacheMap = this.cache.asJavaMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.database.removeListener(this.listener);
        this.cache.removeListener(this.listener);
        this.log.info("Stopped");
    }

    private Map<MappingId, Mapping> getStoreMap(MappingStore.Type type) {
        switch (type) {
            case MAP_DATABASE: {
                return this.databaseMap;
            }
            case MAP_CACHE: {
                return this.cacheMap;
            }
        }
        this.log.warn("Unrecognized map store type {}", (Object)type);
        return Maps.newConcurrentMap();
    }

    private ConsistentMap<MappingId, Mapping> getStore(MappingStore.Type type) {
        switch (type) {
            case MAP_DATABASE: {
                return this.database;
            }
            case MAP_CACHE: {
                return this.cache;
            }
        }
        throw new IllegalArgumentException("Wrong mapping store " + type);
    }

    public int getMappingCount(MappingStore.Type type) {
        AtomicInteger sum = new AtomicInteger(0);
        this.deviceService.getDevices().forEach(device -> sum.addAndGet(Iterables.size(this.getMappingEntries(type, device.id()))));
        return sum.get();
    }

    public Iterable<MappingEntry> getAllMappingEntries(MappingStore.Type type) {
        Map<MappingId, Mapping> storeMap = this.getStoreMap(type);
        return ImmutableList.copyOf((Collection)storeMap.values().stream().map(DefaultMappingEntry::new).collect(Collectors.toList()));
    }

    public MappingEntry getMappingEntry(MappingStore.Type type, Mapping mapping) {
        return new DefaultMappingEntry(this.getStoreMap(type).get(mapping.id()));
    }

    public Iterable<MappingEntry> getMappingEntries(MappingStore.Type type, DeviceId deviceId) {
        Map<MappingId, Mapping> storeMap = this.getStoreMap(type);
        return ImmutableList.copyOf((Collection)storeMap.values().stream().filter(m -> m.deviceId() == deviceId).map(DefaultMappingEntry::new).collect(Collectors.toList()));
    }

    public void storeMapping(MappingStore.Type type, MappingEntry mapping) {
        this.getStore(type).put((Object)mapping.id(), (Object)mapping);
    }

    public MappingEvent removeMapping(MappingStore.Type type, Mapping mapping) {
        this.getStore(type).remove((Object)mapping.id());
        return null;
    }

    public void pendingDeleteMapping(MappingStore.Type type, Mapping mapping) {
        this.log.error("This method will be available when management plane is ready");
    }

    public MappingEvent addOrUpdateMappingEntry(MappingStore.Type type, MappingEntry entry) {
        this.log.error("This method will be available when management plane is ready");
        return null;
    }

    public MappingEvent pendingMappingEntry(MappingStore.Type type, MappingEntry entry) {
        this.log.error("This method will be available when management plane is ready");
        return null;
    }

    public void purgeMappingEntries(MappingStore.Type type) {
        this.getStore(type).clear();
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    private class InternalListener
    implements MapEventListener<MappingId, Mapping> {
        private InternalListener() {
        }

        public void event(MapEvent<MappingId, Mapping> event) {
            Mapping mapping;
            MappingEvent.Type type;
            switch (event.type()) {
                case INSERT: {
                    type = MappingEvent.Type.MAPPING_ADDED;
                    mapping = (Mapping)event.newValue().value();
                    break;
                }
                case UPDATE: {
                    type = MappingEvent.Type.MAPPING_UPDATED;
                    mapping = (Mapping)event.newValue().value();
                    break;
                }
                case REMOVE: {
                    type = MappingEvent.Type.MAPPING_REMOVED;
                    mapping = (Mapping)event.oldValue().value();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong event type " + event.type());
                }
            }
            DistributedMappingStore.this.notifyDelegate((Event)new MappingEvent(type, mapping));
        }
    }
}

