/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.l3vpn.netl3vpn.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.onosproject.l3vpn.netl3vpn.AccessInfo;
import org.onosproject.l3vpn.netl3vpn.BgpDriverInfo;
import org.onosproject.l3vpn.netl3vpn.BgpInfo;
import org.onosproject.l3vpn.netl3vpn.BgpModelIdLevel;
import org.onosproject.l3vpn.netl3vpn.InterfaceInfo;
import org.onosproject.l3vpn.netl3vpn.NetL3VpnException;
import org.onosproject.l3vpn.netl3vpn.VpnType;
import org.onosproject.net.DeviceId;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.DefaultDevice;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.device.Interfaces;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.DefaultL3VpnSvc;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SiteRole;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.DefaultSites;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.DefaultDevices;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.DeviceKeys;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.NetworkInstances;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.DefaultModelObjectData;
import org.onosproject.yang.model.DefaultResourceData;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.KeyInfo;
import org.onosproject.yang.model.ModelObject;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.ModelObjectId;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.model.ResourceId;

public final class NetL3VpnUtil {
    static final String SITE_VPN_MISMATCH = "Site VPN instance name did not match any of the global VPN names";
    static final String VPN_ATTACHMENT_NULL = "The VPN attachment information cannot be null";
    static final String VPN_POLICY_NOT_SUPPORTED = "VPN policy implementation is not supported.";
    static final String CONS_HUNDRED = "100:";
    static final String SITE_ROLE_NULL = "There must be a site role available for the VPN in site network access.";
    static final String BEARER_NULL = "The bearer information of the access is not available";
    static final String IP_INT_INFO_NULL = "The required information of request type or ip connection is not available";
    static final String DEVICE_INFO_NULL = "Bearer of site does not have any device information in the augment info.";
    static final String IP = "ipaddress";
    static final String VPN_TYPE_UNSUPPORTED = "The VPN type is not supported";
    static final String ID_LIMIT_EXCEEDED = "The ID generation has got exceeded";
    static final Long ID_LIMIT = 0xFFFFFFFFL;
    static final String INT_INFO_NULL = "Requested type does not have any interface information in the augment info.";
    static final String PORT_NAME = "portName";
    static final int MAX_EVENTS = 1000;
    static final int MAX_BATCH_MS = 5000;
    static final int MAX_IDLE_MS = 1000;
    static final String TIMER = "dynamic-config-l3vpn-timer";
    static final String UNKNOWN_EVENT = "NetL3VPN listener: unknown event: {}";
    static final String EVENT_NULL = "Event cannot be null";
    private static final String SITE_ROLE_INVALID = "The given site role is invalid";
    private static final String ANY_TO_ANY_ROLE = "AnyToAnyRole";
    private static final String HUB_ROLE = "HubRole";
    private static final String SPOKE_ROLE = "SpokeRole";

    private NetL3VpnUtil() {
    }

    static ModelObjectId getModIdForL3VpnSvc() {
        return ModelObjectId.builder().addChild(DefaultL3VpnSvc.class).build();
    }

    static ModelObjectId getModIdForSites() {
        return ModelObjectId.builder().addChild(DefaultL3VpnSvc.class).addChild(DefaultSites.class).build();
    }

    static ResourceData getResourceData(DataNode dataNode, ResourceId resId) {
        return DefaultResourceData.builder().addDataNode(dataNode).resourceId(resId).build();
    }

    static VpnType getRole(Class<? extends SiteRole> siteRole) {
        switch (siteRole.getSimpleName()) {
            case "AnyToAnyRole": {
                return VpnType.ANY_TO_ANY;
            }
            case "HubRole": {
                return VpnType.HUB;
            }
            case "SpokeRole": {
                return VpnType.SPOKE;
            }
        }
        throw new NetL3VpnException(SITE_ROLE_INVALID);
    }

    static String getMgmtIpUnAvailErr(String ip) {
        return "The device with management ip " + ip + " is not available.";
    }

    private static boolean isDevIdPresent(Map<AccessInfo, InterfaceInfo> info, String id) {
        for (Map.Entry<AccessInfo, InterfaceInfo> inter : info.entrySet()) {
            InterfaceInfo interfaceInfo = inter.getValue();
            DeviceId devId = interfaceInfo.devInfo().deviceId();
            if (!devId.toString().equals(id)) continue;
            return true;
        }
        return false;
    }

    private static ModelObjectData buildInsModDataDevice(String id, NetworkInstances ins) {
        DeviceKeys devKeys = new DeviceKeys();
        devKeys.deviceid(id);
        ModelObjectId modelId = ModelObjectId.builder().addChild(DefaultDevices.class).addChild(org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.DefaultDevice.class, (KeyInfo)devKeys).build();
        return DefaultModelObjectData.builder().identifier(modelId).addModelObject((ModelObject)((InnerModelObject)ins)).build();
    }

    private static ModelObjectData buildInsModDataDevices(String id, NetworkInstances ins) {
        ModelObjectId modelId = ModelObjectId.builder().addChild(DefaultDevices.class).build();
        org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.DefaultDevice device = new org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.DefaultDevice();
        device.deviceid(id);
        device.networkInstances(ins);
        return DefaultModelObjectData.builder().identifier(modelId).addModelObject((ModelObject)((InnerModelObject)device)).build();
    }

    private static ModelObjectData buildInsModDataRoot(String id, NetworkInstances ins) {
        DefaultDevices devices = new DefaultDevices();
        org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.DefaultDevice device = new org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.DefaultDevice();
        LinkedList<org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.DefaultDevice> deviceList = new LinkedList<org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.DefaultDevice>();
        device.deviceid(id);
        device.networkInstances(ins);
        deviceList.add(device);
        devices.device(deviceList);
        return DefaultModelObjectData.builder().addModelObject((ModelObject)((InnerModelObject)devices)).build();
    }

    private static ModelObjectData buildIntModDataDevice(String id, Interfaces ifs) {
        org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.DeviceKeys keys = new org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.DeviceKeys();
        keys.deviceid(id);
        ModelObjectId modelId = ModelObjectId.builder().addChild(org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.DefaultDevices.class).addChild(DefaultDevice.class, (KeyInfo)keys).build();
        return DefaultModelObjectData.builder().identifier(modelId).addModelObject((ModelObject)((InnerModelObject)ifs)).build();
    }

    static ModelObjectData getVpnCreateModObj(Map<AccessInfo, InterfaceInfo> intMap, NetworkInstances instances, String id) {
        boolean devAdded = NetL3VpnUtil.isDevIdPresent(intMap, id);
        ModelObjectData modData = devAdded ? NetL3VpnUtil.buildInsModDataDevice(id, instances) : (intMap.size() != 0 ? NetL3VpnUtil.buildInsModDataDevices(id, instances) : NetL3VpnUtil.buildInsModDataRoot(id, instances));
        return modData;
    }

    static String getIntNotAvailable(String intName) {
        return "The interface " + intName + " is not available.";
    }

    static ModelObjectData getIntCreateModObj(List<String> ifNames, Interfaces ifs, String id) {
        ModelObjectData modData = ifNames.size() > 1 ? NetL3VpnUtil.buildIntModDataDevice(id, ifs) : NetL3VpnUtil.buildIntModDataRoot(id, ifs);
        return modData;
    }

    private static ModelObjectData buildIntModDataRoot(String id, Interfaces ifs) {
        org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.DefaultDevices devices = new org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.DefaultDevices();
        DefaultDevice device = new DefaultDevice();
        LinkedList<DefaultDevice> deviceList = new LinkedList<DefaultDevice>();
        device.deviceid(id);
        device.interfaces(ifs);
        deviceList.add(device);
        devices.device(deviceList);
        return DefaultModelObjectData.builder().addModelObject((ModelObject)((InnerModelObject)devices)).build();
    }

    static BgpDriverInfo getBgpCreateConfigObj(Map<BgpInfo, DeviceId> bgpMap, String id, BgpInfo devBgp, BgpInfo intBgp) {
        boolean isDevIdPresent = NetL3VpnUtil.isDevIdBgpPresent(bgpMap, id);
        BgpDriverInfo info = devBgp != intBgp ? new BgpDriverInfo(BgpModelIdLevel.VPN, id) : (isDevIdPresent ? new BgpDriverInfo(BgpModelIdLevel.DEVICE, id) : (bgpMap.size() != 0 ? new BgpDriverInfo(BgpModelIdLevel.DEVICES, id) : new BgpDriverInfo(BgpModelIdLevel.ROOT, id)));
        return info;
    }

    private static boolean isDevIdBgpPresent(Map<BgpInfo, DeviceId> bgpMap, String id) {
        for (Map.Entry<BgpInfo, DeviceId> info : bgpMap.entrySet()) {
            DeviceId devId = info.getValue();
            if (!devId.toString().equals(id)) continue;
            return true;
        }
        return false;
    }

    static ModelObjectData getVpnDelModObj(Map<AccessInfo, InterfaceInfo> intMap, NetworkInstances ins, String id) {
        boolean isDevIdPresent = NetL3VpnUtil.isDevIdPresent(intMap, id);
        ModelObjectData modData = intMap.size() == 0 ? NetL3VpnUtil.buildInsModDataRoot(id, ins) : (isDevIdPresent ? NetL3VpnUtil.buildInsModDataDevice(id, ins) : NetL3VpnUtil.buildInsModDataDevices(id, ins));
        return modData;
    }

    static BgpDriverInfo getVpnBgpDelModObj(Map<BgpInfo, DeviceId> bgpMap, String id) {
        boolean isDevIdPresent = NetL3VpnUtil.isDevIdBgpPresent(bgpMap, id);
        BgpDriverInfo driInfo = bgpMap.size() == 0 ? new BgpDriverInfo(BgpModelIdLevel.ROOT, id) : (isDevIdPresent ? new BgpDriverInfo(BgpModelIdLevel.DEVICE, id) : new BgpDriverInfo(BgpModelIdLevel.DEVICES, id));
        return driInfo;
    }
}

