/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.l3vpn.netl3vpn.impl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.AbstractAccumulator;
import org.onlab.util.Accumulator;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.config.DynamicConfigEvent;
import org.onosproject.config.DynamicConfigListener;
import org.onosproject.config.DynamicConfigService;
import org.onosproject.config.FailedException;
import org.onosproject.config.Filter;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.EventListener;
import org.onosproject.l3vpn.netl3vpn.AccessInfo;
import org.onosproject.l3vpn.netl3vpn.BgpDriverInfo;
import org.onosproject.l3vpn.netl3vpn.BgpInfo;
import org.onosproject.l3vpn.netl3vpn.DeviceInfo;
import org.onosproject.l3vpn.netl3vpn.FullMeshVpnConfig;
import org.onosproject.l3vpn.netl3vpn.HubSpokeVpnConfig;
import org.onosproject.l3vpn.netl3vpn.InterfaceInfo;
import org.onosproject.l3vpn.netl3vpn.NetL3VpnException;
import org.onosproject.l3vpn.netl3vpn.NetL3VpnStore;
import org.onosproject.l3vpn.netl3vpn.VpnConfig;
import org.onosproject.l3vpn.netl3vpn.VpnInstance;
import org.onosproject.l3vpn.netl3vpn.VpnSiteRole;
import org.onosproject.l3vpn.netl3vpn.VpnType;
import org.onosproject.l3vpn.netl3vpn.impl.BgpConstructionUtil;
import org.onosproject.l3vpn.netl3vpn.impl.InsConstructionUtil;
import org.onosproject.l3vpn.netl3vpn.impl.IntConstructionUtil;
import org.onosproject.l3vpn.netl3vpn.impl.NetL3VpnUtil;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.device.Interfaces;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.DefaultL3VpnSvc;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.L3VpnSvc;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessvpnpolicy.VpnAttachment;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessvpnpolicy.vpnattachment.AttachmentFlavor;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessvpnpolicy.vpnattachment.attachmentflavor.DefaultVpnId;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.DefaultSites;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.Sites;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.VpnServices;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.sites.Site;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.sites.site.SiteNetworkAccesses;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.sites.site.sitenetworkaccesses.SiteNetworkAccess;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.vpnservices.VpnSvc;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentbearer.Bearer;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentbearer.DefaultBearer;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentbearer.bearer.DefaultRequestedType;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentbearer.bearer.RequestedType;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentipconnection.IpConnection;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.RoutingProtocols;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.RoutingProtocol;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.NetworkInstances;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.bearer.DefaultAugmentedL3VpnBearer;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.bearer.requestedtype.DefaultAugmentedL3VpnRequestedType;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.requestedtypegrouping.requestedtypeprofile.RequestedTypeChoice;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.requestedtypegrouping.requestedtypeprofile.requestedtypechoice.DefaultDot1Qcase;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.requestedtypegrouping.requestedtypeprofile.requestedtypechoice.DefaultPhysicalCase;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.DefaultModelObjectData;
import org.onosproject.yang.model.ModelConverter;
import org.onosproject.yang.model.ModelObject;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.ModelObjectId;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.model.ResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class NetL3VpnManager {
    private static final String APP_ID = "org.onosproject.app.l3vpn";
    private static final String L3_VPN_ID_TOPIC = "l3vpn-id";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DynamicConfigListener configListener = new InternalConfigListener();
    private final Accumulator<DynamicConfigEvent> accumulator = new InternalEventAccumulator();
    private final InternalLeadershipListener leadershipEventListener = new InternalLeadershipListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ModelConverter modelConverter;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DynamicConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetL3VpnStore l3VpnStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    protected IdGenerator l3VpnIdGen;
    private NodeId localNodeId;
    private ApplicationId appId;
    private ResourceId id;
    private ResourceId module;
    private ResourceId sites;
    private boolean isElectedLeader;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(APP_ID);
        this.l3VpnIdGen = this.coreService.getIdGenerator(L3_VPN_ID_TOPIC);
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipService.addListener((EventListener)this.leadershipEventListener);
        this.leadershipService.runForLeadership(this.appId.name());
        this.getResourceId();
        this.configService.addListener((EventListener)this.configListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.configService.removeListener((EventListener)this.configListener);
        this.leadershipService.withdraw(this.appId.name());
        this.leadershipService.removeListener((EventListener)this.leadershipEventListener);
        this.log.info("Stopped");
    }

    private String getIdFromGen() {
        Long value;
        Iterable<Long> freeIds = this.l3VpnStore.getFreedIdList();
        Iterator<Long> it = freeIds.iterator();
        if (it.hasNext()) {
            value = it.next();
            this.l3VpnStore.removeIdFromFreeList(value);
        } else {
            value = this.l3VpnIdGen.getNewId();
        }
        if (value > NetL3VpnUtil.ID_LIMIT) {
            throw new RuntimeException("The ID generation has got exceeded");
        }
        return "100:" + String.valueOf(value);
    }

    private void getResourceId() {
        ModelObjectId moduleId = ModelObjectId.builder().build();
        this.module = this.getResourceVal(moduleId);
        ModelObjectId svcId = NetL3VpnUtil.getModIdForL3VpnSvc();
        this.id = this.getResourceVal(svcId);
        ModelObjectId sitesId = NetL3VpnUtil.getModIdForSites();
        this.sites = this.getResourceVal(sitesId);
    }

    private ResourceId getResourceVal(ModelObjectId modelId) {
        DefaultModelObjectData.Builder data = DefaultModelObjectData.builder().identifier(modelId);
        ResourceData resData = this.modelConverter.createDataNode(data.build());
        return resData.resourceId();
    }

    private void processCreateFromStore(ResourceId storeId, DataNode node) {
        if (this.isElectedLeader) {
            List keys = storeId.nodeKeys();
            List<ModelObject> objects = null;
            if (keys.size() == 1) {
                objects = this.getModelObjects(node, this.module);
            } else if (keys.size() == 2) {
                objects = this.getModelObjects(node, this.id);
            }
            if (objects != null) {
                for (ModelObject obj : objects) {
                    if (obj instanceof DefaultL3VpnSvc) {
                        DefaultL3VpnSvc l3VpnSvc = (DefaultL3VpnSvc)obj;
                        this.createGlobalConfig((L3VpnSvc)l3VpnSvc);
                        continue;
                    }
                    if (!(obj instanceof DefaultSites)) continue;
                    DefaultSites sites = (DefaultSites)obj;
                    this.createInterfaceConfig((Sites)sites);
                }
            }
        }
    }

    private void processDeleteFromStore(DataNode dataNode) {
        if (this.isElectedLeader && dataNode == null) {
            this.deleteGlobalConfig(null);
        }
    }

    public List<ModelObject> getModelObjects(DataNode dataNode, ResourceId appId) {
        ResourceData data = NetL3VpnUtil.getResourceData(dataNode, appId);
        ModelObjectData modelData = this.modelConverter.createModel(data);
        return modelData.modelObjects();
    }

    public boolean isSupported(DynamicConfigEvent event) {
        ResourceId rsId = (ResourceId)event.subject();
        List storeKeys = rsId.nodeKeys();
        List regKeys = this.id.nodeKeys();
        List sitesKeys = this.sites.nodeKeys();
        if (storeKeys != null) {
            int storeSize = storeKeys.size();
            if (storeSize == 1) {
                return ((NodeKey)storeKeys.get(0)).equals(regKeys.get(1)) && (event.type() == DynamicConfigEvent.Type.NODE_ADDED || event.type() == DynamicConfigEvent.Type.NODE_DELETED);
            }
            if (storeSize == 2) {
                return ((NodeKey)storeKeys.get(0)).equals(sitesKeys.get(1)) && ((NodeKey)storeKeys.get(1)).equals(sitesKeys.get(2)) && (event.type() == DynamicConfigEvent.Type.NODE_ADDED || event.type() == DynamicConfigEvent.Type.NODE_DELETED);
            }
        }
        return false;
    }

    void createGlobalConfig(L3VpnSvc l3VpnSvc) {
        if (l3VpnSvc.vpnServices() != null) {
            this.createVpnServices(l3VpnSvc.vpnServices());
        }
        if (l3VpnSvc.sites() != null) {
            this.createInterfaceConfig(l3VpnSvc.sites());
        }
    }

    private void createVpnServices(VpnServices vpnSvcs) {
        if (vpnSvcs != null && vpnSvcs.vpnSvc() != null) {
            List svcList = vpnSvcs.vpnSvc();
            for (VpnSvc svc : svcList) {
                String vpnName = svc.vpnId().string();
                this.l3VpnStore.addVpnInsIfAbsent(vpnName, new VpnInstance(vpnName));
            }
        }
    }

    private void createInterfaceConfig(Sites sites) {
        if (sites.site() != null) {
            List sitesList = sites.site();
            for (Site site : sitesList) {
                if (site.siteNetworkAccesses() == null) continue;
                SiteNetworkAccesses accesses = site.siteNetworkAccesses();
                List accessList = accesses.siteNetworkAccess();
                for (SiteNetworkAccess access : accessList) {
                    this.createFromAccess(access, site.siteId().string());
                }
            }
        }
    }

    private void createFromAccess(SiteNetworkAccess access, String siteId) {
        Map<AccessInfo, InterfaceInfo> intMap = this.l3VpnStore.getInterfaceInfo();
        Map<String, VpnInstance> insMap = this.l3VpnStore.getVpnInstances();
        String accessId = access.siteNetworkAccessId().string();
        AccessInfo info = new AccessInfo(siteId, accessId);
        if (intMap.get(info) == null) {
            VpnSiteRole siteRole = this.getSiteRole(access.vpnAttachment());
            VpnInstance instance = insMap.get(siteRole.name());
            if (instance == null) {
                throw new NetL3VpnException("Site VPN instance name did not match any of the global VPN names");
            }
            this.buildFromAccess(instance, info, access, siteRole);
        }
    }

    private VpnSiteRole getSiteRole(VpnAttachment attach) {
        if (attach == null || attach.attachmentFlavor() == null) {
            throw new NetL3VpnException("The VPN attachment information cannot be null");
        }
        AttachmentFlavor flavor = attach.attachmentFlavor();
        if (!(flavor instanceof DefaultVpnId)) {
            throw new NetL3VpnException("VPN policy implementation is not supported.");
        }
        DefaultVpnId vpnId = (DefaultVpnId)flavor;
        if (vpnId.siteRole() == null) {
            throw new NetL3VpnException("There must be a site role available for the VPN in site network access.");
        }
        VpnType role = NetL3VpnUtil.getRole(vpnId.siteRole());
        return new VpnSiteRole(String.valueOf(vpnId.vpnId()), role);
    }

    private void buildFromAccess(VpnInstance instance, AccessInfo info, SiteNetworkAccess access, VpnSiteRole role) {
        Bearer bearer = access.bearer();
        if (bearer == null) {
            throw new NetL3VpnException("The bearer information of the access is not available");
        }
        RequestedType reqType = bearer.requestedType();
        IpConnection connect = access.ipConnection();
        RoutingProtocols pro = access.routingProtocols();
        if (reqType == null || connect == null) {
            throw new NetL3VpnException("The required information of request type or ip connection is not available");
        }
        this.buildDeviceDetails(instance, info, role, bearer, connect, reqType, pro);
    }

    private void buildDeviceDetails(VpnInstance instance, AccessInfo accInfo, VpnSiteRole role, Bearer bearer, IpConnection connect, RequestedType reqType, RoutingProtocols pro) {
        Map<AccessInfo, InterfaceInfo> interMap = this.l3VpnStore.getInterfaceInfo();
        InterfaceInfo intInfo = interMap.get(accInfo);
        if (intInfo != null) {
            return;
        }
        DeviceInfo info = this.buildDevVpnIns(bearer, instance, role, connect);
        String portName = this.getInterfaceName(info, reqType);
        this.buildDevVpnInt(info, instance, connect, portName, accInfo);
        if (pro != null && pro.routingProtocol() != null) {
            this.buildBgpInfo(pro.routingProtocol(), info, role.name(), connect, accInfo);
        }
        InterfaceInfo interInfo = new InterfaceInfo(info, portName, instance.vpnName());
        this.l3VpnStore.addInterfaceInfo(accInfo, interInfo);
        this.l3VpnStore.addVpnIns(instance.vpnName(), instance);
    }

    private DeviceInfo buildDevVpnIns(Bearer bearer, VpnInstance ins, VpnSiteRole role, IpConnection connect) {
        DefaultAugmentedL3VpnBearer augBearer = (DefaultAugmentedL3VpnBearer)((DefaultBearer)bearer).augmentation(DefaultAugmentedL3VpnBearer.class);
        DeviceId id = this.getDeviceId(augBearer);
        Map<DeviceId, DeviceInfo> devices = ins.devInfo();
        DeviceInfo info = null;
        if (devices != null) {
            info = devices.get(id);
        }
        if (info == null) {
            info = this.createVpnInstance(id, role, ins, connect);
        }
        return info;
    }

    private DeviceId getDeviceId(DefaultAugmentedL3VpnBearer attach) {
        if (attach == null || attach.bearerAttachment() == null || attach.bearerAttachment().peMgmtIp() == null || attach.bearerAttachment().peMgmtIp().string() == null) {
            throw new NetL3VpnException("Bearer of site does not have any device information in the augment info.");
        }
        String ip = attach.bearerAttachment().peMgmtIp().string();
        return this.getId(ip);
    }

    public DeviceId getId(String ip) {
        for (Device device : this.deviceService.getAvailableDevices()) {
            String val = device.annotations().value("ipaddress");
            if (!ip.equals(val)) continue;
            return device.id();
        }
        throw new NetL3VpnException(NetL3VpnUtil.getMgmtIpUnAvailErr(ip));
    }

    private DeviceInfo createVpnInstance(DeviceId id, VpnSiteRole role, VpnInstance inst, IpConnection ip) {
        Map<AccessInfo, InterfaceInfo> intMap = this.l3VpnStore.getInterfaceInfo();
        this.generateRdRt(inst, role);
        DeviceInfo info = new DeviceInfo(id);
        NetworkInstances instances = InsConstructionUtil.createInstance(inst, role, ip);
        ModelObjectData devMod = NetL3VpnUtil.getVpnCreateModObj(intMap, instances, id.toString());
        ModelObjectData driMod = info.processCreateInstance(this.driverService, devMod);
        ResourceData resData = this.modelConverter.createDataNode(driMod);
        this.addToStore(resData);
        this.l3VpnStore.addVpnIns(inst.vpnName(), inst);
        inst.addDevInfo(id, info);
        return info;
    }

    private void addToStore(ResourceData resData) {
        if (resData != null && resData.dataNodes() != null) {
            List dataNodes = resData.dataNodes();
            for (DataNode node : dataNodes) {
                this.configService.createNodeRecursive(resData.resourceId(), node);
            }
        }
    }

    private void generateRdRt(VpnInstance ins, VpnSiteRole role) {
        ins.type(role.role());
        Object config = ins.vpnConfig();
        String rd = null;
        if (config == null) {
            rd = this.getIdFromGen();
        }
        switch (ins.type()) {
            case ANY_TO_ANY: {
                if (config != null) break;
                config = new FullMeshVpnConfig(rd);
                ((VpnConfig)config).rd(rd);
                break;
            }
            case HUB: 
            case SPOKE: {
                if (config == null) {
                    config = new HubSpokeVpnConfig();
                    ((VpnConfig)config).rd(rd);
                }
                this.createImpRtVal((HubSpokeVpnConfig)config, ins.type());
                this.createExpRtVal((HubSpokeVpnConfig)config, ins.type());
                break;
            }
            default: {
                throw new NetL3VpnException("The VPN type is not supported");
            }
        }
        ins.vpnConfig(config);
    }

    private void createImpRtVal(HubSpokeVpnConfig config, VpnType type) {
        if (type == VpnType.HUB) {
            if (config.hubImpRt() != null) {
                return;
            }
            this.setHubImpRt(config);
        } else {
            if (config.spokeImpRt() != null) {
                return;
            }
            config.spokeImpRt(config.rd());
        }
    }

    public void setHubImpRt(HubSpokeVpnConfig config) {
        String hubImp = config.spokeExpRt() != null ? config.spokeExpRt() : this.getIdFromGen();
        config.hubImpRt(hubImp);
    }

    private void createExpRtVal(HubSpokeVpnConfig config, VpnType type) {
        if (type == VpnType.HUB) {
            if (config.hubExpRt() != null) {
                return;
            }
            config.hubExpRt(config.rd());
        } else {
            if (config.spokeExpRt() != null) {
                return;
            }
            this.setSpokeExpRt(config);
        }
    }

    public void setSpokeExpRt(HubSpokeVpnConfig config) {
        String spokeExp = config.hubImpRt() != null ? config.hubImpRt() : this.getIdFromGen();
        config.spokeExpRt(spokeExp);
    }

    private String getInterfaceName(DeviceInfo info, RequestedType reqType) {
        DefaultAugmentedL3VpnRequestedType req = (DefaultAugmentedL3VpnRequestedType)((DefaultRequestedType)reqType).augmentation(DefaultAugmentedL3VpnRequestedType.class);
        if (req == null || req.requestedTypeProfile() == null || req.requestedTypeProfile().requestedTypeChoice() == null) {
            throw new NetL3VpnException("Requested type does not have any interface information in the augment info.");
        }
        RequestedTypeChoice reqChoice = req.requestedTypeProfile().requestedTypeChoice();
        return this.getNameFromChoice(reqChoice, info.deviceId());
    }

    private String getNameFromChoice(RequestedTypeChoice choice, DeviceId id) {
        String intName;
        if (choice == null) {
            throw new NetL3VpnException("Requested type does not have any interface information in the augment info.");
        }
        if (choice instanceof DefaultDot1Qcase) {
            if (((DefaultDot1Qcase)choice).dot1q() == null || ((DefaultDot1Qcase)choice).dot1q().physicalIf() == null) {
                throw new NetL3VpnException("Requested type does not have any interface information in the augment info.");
            }
            intName = ((DefaultDot1Qcase)choice).dot1q().physicalIf();
        } else {
            if (((DefaultPhysicalCase)choice).physical() == null || ((DefaultPhysicalCase)choice).physical().physicalIf() == null) {
                throw new NetL3VpnException("Requested type does not have any interface information in the augment info.");
            }
            intName = ((DefaultPhysicalCase)choice).physical().physicalIf();
        }
        return this.getPortName(intName, id);
    }

    private String getPortName(String intName, DeviceId id) {
        List ports = this.deviceService.getPorts(id);
        for (Port port : ports) {
            String pName = port.annotations().value("portName");
            if (!pName.equals(intName)) continue;
            return intName;
        }
        throw new NetL3VpnException(NetL3VpnUtil.getIntNotAvailable(intName));
    }

    private void buildDevVpnInt(DeviceInfo info, VpnInstance ins, IpConnection connect, String pName, AccessInfo access) {
        Map<AccessInfo, InterfaceInfo> intMap = this.l3VpnStore.getInterfaceInfo();
        info.addAccessInfo(access);
        info.addIfName(pName);
        Interfaces interfaces = IntConstructionUtil.createInterface(pName, ins.vpnName(), connect);
        ModelObjectData devMod = NetL3VpnUtil.getIntCreateModObj(info.ifNames(), interfaces, info.deviceId().toString());
        ModelObjectData driMod = info.processCreateInterface(this.driverService, devMod);
        ResourceData resData = this.modelConverter.createDataNode(driMod);
        this.addToStore(resData);
    }

    private void buildBgpInfo(List<RoutingProtocol> routes, DeviceInfo info, String name, IpConnection connect, AccessInfo access) {
        Map<BgpInfo, DeviceId> bgpMap = this.l3VpnStore.getBgpInfo();
        BgpInfo intBgp = BgpConstructionUtil.createBgpInfo(routes, info, name, connect, access);
        if (intBgp != null) {
            intBgp.vpnName(name);
            BgpDriverInfo config = NetL3VpnUtil.getBgpCreateConfigObj(bgpMap, info.deviceId().toString(), info.bgpInfo(), intBgp);
            ModelObjectData driData = info.processCreateBgpInfo(this.driverService, intBgp, config);
            this.l3VpnStore.addBgpInfo(info.bgpInfo(), info.deviceId());
            ResourceData resData = this.modelConverter.createDataNode(driData);
            this.addToStore(resData);
        }
    }

    void deleteGlobalConfig(L3VpnSvc l3VpnSvc) {
        this.deleteGlobalVpn(l3VpnSvc);
    }

    private void deleteGlobalVpn(L3VpnSvc l3VpnSvc) {
        Map<String, VpnInstance> insMap = this.l3VpnStore.getVpnInstances();
        if (l3VpnSvc == null || l3VpnSvc.vpnServices() == null || l3VpnSvc.vpnServices().vpnSvc() == null) {
            for (Map.Entry<String, VpnInstance> vpnMap : insMap.entrySet()) {
                this.deleteVpnInstance(vpnMap.getValue(), false);
            }
            return;
        }
        List vpnList = l3VpnSvc.vpnServices().vpnSvc();
        for (Map.Entry<String, VpnInstance> vpnMap : insMap.entrySet()) {
            boolean isPresent = this.isVpnPresent(vpnMap.getKey(), vpnList);
            if (isPresent) continue;
            this.deleteVpnInstance(vpnMap.getValue(), false);
        }
    }

    private boolean isVpnPresent(String vpnName, List<VpnSvc> vpnList) {
        for (VpnSvc svc : vpnList) {
            if (!svc.vpnId().string().equals(vpnName)) continue;
            return true;
        }
        return false;
    }

    private void deleteVpnInstance(VpnInstance instance, boolean isIntDeleted) {
        Map<DeviceId, DeviceInfo> devices = instance.devInfo();
        if (devices != null) {
            for (Map.Entry<DeviceId, DeviceInfo> device : devices.entrySet()) {
                NetworkInstances ins = InsConstructionUtil.deleteInstance(instance.vpnName());
                DeviceInfo dev = device.getValue();
                if (!isIntDeleted) {
                    this.remVpnBgp(dev);
                    this.remInterfaceFromMap(dev);
                }
                Map<AccessInfo, InterfaceInfo> intMap = this.l3VpnStore.getInterfaceInfo();
                String id = dev.deviceId().toString();
                ModelObjectData devMod = NetL3VpnUtil.getVpnDelModObj(intMap, ins, id);
                ModelObjectData driMod = dev.processDeleteInstance(this.driverService, devMod);
                ResourceData resData = this.modelConverter.createDataNode(driMod);
                this.deleteFromStore(resData);
            }
            this.l3VpnStore.removeVpnInstance(instance.vpnName());
        }
    }

    private void remVpnBgp(DeviceInfo dev) {
        BgpInfo devBgp = dev.bgpInfo();
        if (devBgp != null) {
            this.l3VpnStore.removeBgpInfo(devBgp);
            BgpInfo delInfo = new BgpInfo();
            delInfo.vpnName(devBgp.vpnName());
            String id = dev.deviceId().toString();
            Map<BgpInfo, DeviceId> bgpMap = this.l3VpnStore.getBgpInfo();
            BgpDriverInfo driConfig = NetL3VpnUtil.getVpnBgpDelModObj(bgpMap, id);
            ModelObjectData driData = dev.processDeleteBgpInfo(this.driverService, delInfo, driConfig);
            ResourceData resData = this.modelConverter.createDataNode(driData);
            this.deleteFromStore(resData);
            this.l3VpnStore.removeBgpInfo(devBgp);
        }
    }

    private void deleteFromStore(ResourceData resData) {
        if (resData != null) {
            this.configService.deleteNodeRecursive(resData.resourceId());
        }
    }

    private void remInterfaceFromMap(DeviceInfo deviceInfo) {
        List<AccessInfo> accesses = deviceInfo.accesses();
        if (accesses != null) {
            for (AccessInfo access : accesses) {
                this.l3VpnStore.removeInterfaceInfo(access);
            }
        }
        deviceInfo.ifNames(null);
        deviceInfo.accesses(null);
    }

    private void leaderChanged(boolean isLeader) {
        this.log.debug("Leader changed: {}", (Object)isLeader);
        this.isElectedLeader = isLeader;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindModelConverter(ModelConverter modelConverter) {
        this.modelConverter = modelConverter;
    }

    protected void unbindModelConverter(ModelConverter modelConverter) {
        if (this.modelConverter == modelConverter) {
            this.modelConverter = null;
        }
    }

    protected void bindConfigService(DynamicConfigService dynamicConfigService) {
        this.configService = dynamicConfigService;
    }

    protected void unbindConfigService(DynamicConfigService dynamicConfigService) {
        if (this.configService == dynamicConfigService) {
            this.configService = null;
        }
    }

    protected void bindL3VpnStore(NetL3VpnStore netL3VpnStore) {
        this.l3VpnStore = netL3VpnStore;
    }

    protected void unbindL3VpnStore(NetL3VpnStore netL3VpnStore) {
        if (this.l3VpnStore == netL3VpnStore) {
            this.l3VpnStore = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private class InternalLeadershipListener
    implements LeadershipEventListener {
        private InternalLeadershipListener() {
        }

        public boolean isRelevant(LeadershipEvent event) {
            return ((Leadership)event.subject()).topic().equals(NetL3VpnManager.this.appId.name());
        }

        public void event(LeadershipEvent event) {
            switch ((LeadershipEvent.Type)event.type()) {
                case LEADER_CHANGED: 
                case LEADER_AND_CANDIDATES_CHANGED: {
                    if (NetL3VpnManager.this.localNodeId.equals((Object)((Leadership)event.subject()).leaderNodeId())) {
                        NetL3VpnManager.this.log.info("Net l3vpn manager gained leadership");
                        NetL3VpnManager.this.leaderChanged(true);
                        break;
                    }
                    NetL3VpnManager.this.log.info("Net l3vpn manager leader changed. New leader is {}", (Object)((Leadership)event.subject()).leaderNodeId());
                    NetL3VpnManager.this.leaderChanged(false);
                }
            }
        }
    }

    private class InternalEventAccumulator
    extends AbstractAccumulator<DynamicConfigEvent> {
        protected InternalEventAccumulator() {
            super(new Timer("dynamic-config-l3vpn-timer"), 1000, 5000, 1000);
        }

        public void processItems(List<DynamicConfigEvent> events) {
            block6: for (DynamicConfigEvent event : events) {
                DataNode node;
                Preconditions.checkNotNull((Object)event, (Object)"Event cannot be null");
                Filter filter = new Filter();
                try {
                    node = NetL3VpnManager.this.configService.readNode((ResourceId)event.subject(), filter);
                }
                catch (FailedException e) {
                    node = null;
                }
                switch ((DynamicConfigEvent.Type)event.type()) {
                    case NODE_ADDED: {
                        NetL3VpnManager.this.processCreateFromStore((ResourceId)event.subject(), node);
                        continue block6;
                    }
                    case NODE_DELETED: {
                        NetL3VpnManager.this.processDeleteFromStore(node);
                        continue block6;
                    }
                }
                NetL3VpnManager.this.log.warn("NetL3VPN listener: unknown event: {}", (Object)event.type());
            }
        }
    }

    private class InternalConfigListener
    implements DynamicConfigListener {
        private InternalConfigListener() {
        }

        public boolean isRelevant(DynamicConfigEvent event) {
            return NetL3VpnManager.this.isSupported(event);
        }

        public void event(DynamicConfigEvent event) {
            NetL3VpnManager.this.accumulator.add((Object)event);
        }
    }
}

