/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.l3vpn.netl3vpn.impl;

import java.util.LinkedList;
import org.onosproject.l3vpn.netl3vpn.NetL3VpnException;
import org.onosproject.yang.gen.v1.ietfinettypes.rev20130715.ietfinettypes.Ipv4Address;
import org.onosproject.yang.gen.v1.ietfinettypes.rev20130715.ietfinettypes.Ipv4AddressNoZone;
import org.onosproject.yang.gen.v1.ietfinettypes.rev20130715.ietfinettypes.Ipv6Address;
import org.onosproject.yang.gen.v1.ietfinettypes.rev20130715.ietfinettypes.Ipv6AddressNoZone;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.device.DefaultInterfaces;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.device.Interfaces;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.device.interfaces.DefaultYangAutoPrefixInterface;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.device.interfaces.YangAutoPrefixInterface;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.AugmentedIfInterface;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.DefaultAugmentedIfInterface;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.DefaultIpv4;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.DefaultIpv6;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.Ipv4;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.Ipv6;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv4.DefaultAddress;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv4.address.Subnet;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv4.address.subnet.DefaultPrefixLength;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentipconnection.IpConnection;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.interfaces.yangautoprefixinterface.ipv4.DefaultAugmentedIpIpv4;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.interfaces.yangautoprefixinterface.ipv6.DefaultAugmentedIpIpv6;
import org.onosproject.yang.model.InnerModelObject;

public final class IntConstructionUtil {
    private static final String IP_ADD_NULL = "Vpn binding to an interface requires ip address.";

    private IntConstructionUtil() {
    }

    public static Interfaces createInterface(String pName, String vpnName, IpConnection connect) {
        DefaultInterfaces interfaces = new DefaultInterfaces();
        LinkedList<YangAutoPrefixInterface> intList = new LinkedList<YangAutoPrefixInterface>();
        YangAutoPrefixInterface inter = IntConstructionUtil.buildInterface(vpnName, pName, connect);
        intList.add(inter);
        interfaces.yangAutoPrefixInterface(intList);
        return interfaces;
    }

    private static YangAutoPrefixInterface buildInterface(String vpnName, String pName, IpConnection connect) {
        org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.interfaces.yangautoprefixinterface.DefaultAugmentedIfInterface augIf = new org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.interfaces.yangautoprefixinterface.DefaultAugmentedIfInterface();
        augIf.bindNetworkInstanceName(vpnName);
        AugmentedIfInterface intAug = IntConstructionUtil.buildIpAddress(connect, vpnName);
        DefaultYangAutoPrefixInterface inter = new DefaultYangAutoPrefixInterface();
        inter.name(pName);
        inter.addAugmentation((InnerModelObject)augIf);
        inter.addAugmentation((InnerModelObject)intAug);
        return inter;
    }

    private static Ipv6 getIpv6Aug(String vpnName, short mask, String ipv6Add) {
        DefaultAugmentedIpIpv6 augIpv6 = new DefaultAugmentedIpIpv6();
        org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv6.DefaultAddress add = new org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv6.DefaultAddress();
        DefaultIpv6 ipv6 = new DefaultIpv6();
        LinkedList<org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv6.DefaultAddress> addList = new LinkedList<org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv6.DefaultAddress>();
        add.ip(Ipv6AddressNoZone.of((Ipv6Address)Ipv6Address.of((String)ipv6Add)));
        augIpv6.bindNetworkInstanceName(vpnName);
        add.prefixLength(mask);
        addList.add(add);
        ipv6.address(addList);
        ipv6.addAugmentation((InnerModelObject)augIpv6);
        return ipv6;
    }

    private static Ipv4 getIpv4Aug(String vpnName, short mask, String ipv4Add) {
        DefaultAugmentedIpIpv4 augIpv4 = new DefaultAugmentedIpIpv4();
        DefaultPrefixLength net = new DefaultPrefixLength();
        DefaultAddress add = new DefaultAddress();
        DefaultIpv4 ipv4 = new DefaultIpv4();
        LinkedList<DefaultAddress> addList = new LinkedList<DefaultAddress>();
        augIpv4.bindNetworkInstanceName(vpnName);
        net.prefixLength(mask);
        add.ip(Ipv4AddressNoZone.of((Ipv4Address)Ipv4Address.of((String)ipv4Add)));
        add.subnet((Subnet)net);
        addList.add(add);
        ipv4.address(addList);
        ipv4.addAugmentation((InnerModelObject)augIpv4);
        return ipv4;
    }

    public static AugmentedIfInterface buildIpAddress(IpConnection connect, String vpnName) {
        short mask;
        if (connect == null || connect.ipv4() == null && connect.ipv6() == null) {
            throw new NetL3VpnException(IP_ADD_NULL);
        }
        DefaultAugmentedIfInterface intAug = new DefaultAugmentedIfInterface();
        if (connect.ipv4() != null) {
            mask = connect.ipv4().addresses().mask();
            Ipv4Address peIpv4 = connect.ipv4().addresses().providerAddress();
            Ipv4 v4 = IntConstructionUtil.getIpv4Aug(vpnName, mask, peIpv4.string());
            intAug.ipv4(v4);
        }
        if (connect.ipv6() != null) {
            mask = connect.ipv6().addresses().mask();
            Ipv6Address peIpv6 = connect.ipv6().addresses().providerAddress();
            Ipv6 v6 = IntConstructionUtil.getIpv6Aug(vpnName, mask, peIpv6.string());
            intAug.ipv6(v6);
        }
        return intAug;
    }
}

