/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.l3vpn.netl3vpn.impl;

import java.util.LinkedList;
import org.onosproject.l3vpn.netl3vpn.FullMeshVpnConfig;
import org.onosproject.l3vpn.netl3vpn.HubSpokeVpnConfig;
import org.onosproject.l3vpn.netl3vpn.VpnConfig;
import org.onosproject.l3vpn.netl3vpn.VpnInstance;
import org.onosproject.l3vpn.netl3vpn.VpnSiteRole;
import org.onosproject.l3vpn.netl3vpn.VpnType;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.devices.device.networkinstances.networkinstance.DefaultAugmentedNiNetworkInstance;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.devices.device.networkinstances.networkinstance.augmentedninetworkinstance.DefaultL3Vpn;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.devices.device.networkinstances.networkinstance.augmentedninetworkinstance.L3Vpn;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.l3vpnvrfparams.DefaultIpv4;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.l3vpnvrfparams.DefaultIpv6;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.l3vpnvrfparams.Ipv4;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.l3vpnvrfparams.Ipv6;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.l3vpnvrfparams.ipv4.DefaultUnicast;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.l3vpnvrfparams.ipv6.Unicast;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routedistinguisherparams.DefaultRouteDistinguisher;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routedistinguisherparams.RouteDistinguisher;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routetargetparams.DefaultRouteTargets;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routetargetparams.RouteTargets;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routetargetparams.routetargets.Config;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routetargetparams.routetargets.DefaultConfig;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routetargetset.DefaultRts;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routetargetset.Rts;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routetargetset.rts.RtTypeEnum;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentipconnection.IpConnection;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.DefaultNetworkInstances;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.NetworkInstances;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.networkinstances.DefaultNetworkInstance;
import org.onosproject.yang.model.InnerModelObject;

public final class InsConstructionUtil {
    private InsConstructionUtil() {
    }

    public static NetworkInstances createInstance(VpnInstance vpnIns, VpnSiteRole role, IpConnection connect) {
        DefaultNetworkInstance ins = new DefaultNetworkInstance();
        DefaultNetworkInstances instances = new DefaultNetworkInstances();
        LinkedList<DefaultNetworkInstance> insList = new LinkedList<DefaultNetworkInstance>();
        L3Vpn l3Vpn = InsConstructionUtil.buildRd(vpnIns);
        DefaultAugmentedNiNetworkInstance augIns = InsConstructionUtil.buildRt(connect, role, l3Vpn, vpnIns);
        ins.name(vpnIns.vpnName());
        insList.add(ins);
        ins.addAugmentation((InnerModelObject)augIns);
        instances.networkInstance(insList);
        return instances;
    }

    private static DefaultAugmentedNiNetworkInstance buildRt(IpConnection con, VpnSiteRole role, L3Vpn l3Vpn, VpnInstance ins) {
        Ipv4 ipv4 = null;
        Ipv6 ipv6 = null;
        if (con.ipv4() != null && con.ipv4().addresses().providerAddress() != null) {
            ipv4 = InsConstructionUtil.buildIpv4Rt(role, ins);
        }
        if (con.ipv6() != null && con.ipv6().addresses().providerAddress() != null) {
            ipv6 = InsConstructionUtil.buildIpv6Rt(role, ins);
        }
        l3Vpn.ipv4(ipv4);
        l3Vpn.ipv6(ipv6);
        DefaultAugmentedNiNetworkInstance augInst = new DefaultAugmentedNiNetworkInstance();
        augInst.l3Vpn(l3Vpn);
        return augInst;
    }

    private static Ipv6 buildIpv6Rt(VpnSiteRole role, VpnInstance vpnIns) {
        DefaultRouteTargets rts6 = new DefaultRouteTargets();
        DefaultIpv6 v6 = new DefaultIpv6();
        org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.l3vpnvrfparams.ipv6.DefaultUnicast uni6 = new org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.l3vpnvrfparams.ipv6.DefaultUnicast();
        Config configV6 = InsConstructionUtil.configRouteTarget(vpnIns, role);
        rts6.config(configV6);
        uni6.routeTargets((RouteTargets)rts6);
        v6.unicast((Unicast)uni6);
        return v6;
    }

    private static Ipv4 buildIpv4Rt(VpnSiteRole role, VpnInstance vpnIns) {
        DefaultRouteTargets rts4 = new DefaultRouteTargets();
        DefaultUnicast uni4 = new DefaultUnicast();
        DefaultIpv4 v4 = new DefaultIpv4();
        Config configV4 = InsConstructionUtil.configRouteTarget(vpnIns, role);
        rts4.config(configV4);
        uni4.routeTargets((RouteTargets)rts4);
        v4.unicast((org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.l3vpnvrfparams.ipv4.Unicast)uni4);
        return v4;
    }

    private static Config configRouteTarget(VpnInstance ins, VpnSiteRole role) {
        Rts rts1;
        DefaultConfig config = new DefaultConfig();
        LinkedList<Rts> rtsList = new LinkedList<Rts>();
        if (ins.type() == VpnType.ANY_TO_ANY) {
            String rtVal = ((FullMeshVpnConfig)ins.vpnConfig()).rt();
            rts1 = InsConstructionUtil.getRtsVal(rtVal, RtTypeEnum.BOTH);
        } else {
            String rtVal2;
            String rtVal1;
            HubSpokeVpnConfig conf = (HubSpokeVpnConfig)ins.vpnConfig();
            if (role.role() == VpnType.HUB) {
                rtVal1 = conf.hubImpRt();
                rtVal2 = conf.hubExpRt();
            } else {
                rtVal1 = conf.spokeImpRt();
                rtVal2 = conf.spokeExpRt();
            }
            rts1 = InsConstructionUtil.getRtsVal(rtVal1, RtTypeEnum.IMPORT);
            Rts rts2 = InsConstructionUtil.getRtsVal(rtVal2, RtTypeEnum.EXPORT);
            rtsList.add(rts2);
        }
        rtsList.add(rts1);
        config.rts(rtsList);
        return config;
    }

    private static Rts getRtsVal(String rtVal, RtTypeEnum type) {
        DefaultRts rts = new DefaultRts();
        rts.rt(rtVal);
        rts.rtType(type);
        return rts;
    }

    private static L3Vpn buildRd(VpnInstance vpn) {
        String rd = ((VpnConfig)vpn.vpnConfig()).rd();
        org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routedistinguisherparams.routedistinguisher.DefaultConfig config = new org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routedistinguisherparams.routedistinguisher.DefaultConfig();
        config.rd(rd);
        DefaultRouteDistinguisher dist = new DefaultRouteDistinguisher();
        dist.config((org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routedistinguisherparams.routedistinguisher.Config)config);
        DefaultL3Vpn l3vpn = new DefaultL3Vpn();
        l3vpn.routeDistinguisher((RouteDistinguisher)dist);
        return l3vpn;
    }

    static NetworkInstances deleteInstance(String vpnName) {
        DefaultNetworkInstance nwInstance = new DefaultNetworkInstance();
        LinkedList<DefaultNetworkInstance> insList = new LinkedList<DefaultNetworkInstance>();
        DefaultNetworkInstances instances = new DefaultNetworkInstances();
        nwInstance.name(vpnName);
        insList.add(nwInstance);
        instances.networkInstance(insList);
        return instances;
    }
}

