/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.l3vpn.netl3vpn.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.l3vpn.netl3vpn.AccessInfo;
import org.onosproject.l3vpn.netl3vpn.BgpInfo;
import org.onosproject.l3vpn.netl3vpn.DeviceInfo;
import org.onosproject.l3vpn.netl3vpn.FullMeshVpnConfig;
import org.onosproject.l3vpn.netl3vpn.HubSpokeVpnConfig;
import org.onosproject.l3vpn.netl3vpn.InterfaceInfo;
import org.onosproject.l3vpn.netl3vpn.NetL3VpnStore;
import org.onosproject.l3vpn.netl3vpn.ProtocolInfo;
import org.onosproject.l3vpn.netl3vpn.RouteProtocol;
import org.onosproject.l3vpn.netl3vpn.VpnConfig;
import org.onosproject.l3vpn.netl3vpn.VpnInstance;
import org.onosproject.l3vpn.netl3vpn.VpnType;
import org.onosproject.net.DeviceId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.onosproject.yang.model.LeafListKey;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.SchemaId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedNetL3VpnStore
implements NetL3VpnStore {
    private static final Serializer L3VPN_SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(KryoNamespaces.API).register(new Class[]{VpnInstance.class}).register(new Class[]{VpnType.class}).register(new Class[]{VpnConfig.class}).register(new Class[]{FullMeshVpnConfig.class}).register(new Class[]{HubSpokeVpnConfig.class}).register(new Class[]{DeviceInfo.class}).register(new Class[]{ResourceId.class}).register(new Class[]{NodeKey.class}).register(new Class[]{SchemaId.class}).register(new Class[]{LeafListKey.class}).register(new Class[]{ListKey.class}).register(new Class[]{AccessInfo.class}).register(new Class[]{InterfaceInfo.class}).register(new Class[]{BgpInfo.class}).register(new Class[]{RouteProtocol.class}).register(new Class[]{ProtocolInfo.class}).build());
    private static final String FREE_ID_NULL = "Free ID cannot be null";
    private static final String VPN_NAME_NULL = "VPN name cannot be null";
    private static final String VPN_INS_NULL = "VPN instance cannot be null";
    private static final String ACCESS_INFO_NULL = "Access info cannot be null";
    private static final String BGP_INFO_NULL = "BGP info cannot be null";
    private static final String INT_INFO_NULL = "Interface info cannot be null";
    private static final String DEV_ID_NULL = "Device Id cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private DistributedSet<Long> freedIdList;
    private ConsistentMap<AccessInfo, InterfaceInfo> intInfoMap;
    private ConsistentMap<String, VpnInstance> vpnInsMap;
    private ConsistentMap<BgpInfo, DeviceId> bgpInfoMap;

    @Activate
    protected void activate() {
        this.vpnInsMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-l3vpn-instance-map")).withSerializer(L3VPN_SERIALIZER)).build();
        this.intInfoMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-l3vpn-int-info-map")).withSerializer(L3VPN_SERIALIZER)).build();
        this.bgpInfoMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-l3vpn-bgp-info-map")).withSerializer(L3VPN_SERIALIZER)).build();
        this.freedIdList = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("onos-l3vpn-id-freed-list")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build()).asDistributedSet();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public Iterable<Long> getFreedIdList() {
        return ImmutableSet.copyOf(this.freedIdList);
    }

    @Override
    public Map<String, VpnInstance> getVpnInstances() {
        return this.vpnInsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (VpnInstance)((Versioned)e.getValue()).value()));
    }

    @Override
    public Map<BgpInfo, DeviceId> getBgpInfo() {
        return this.bgpInfoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (DeviceId)((Versioned)e.getValue()).value()));
    }

    @Override
    public Map<AccessInfo, InterfaceInfo> getInterfaceInfo() {
        return this.intInfoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (InterfaceInfo)((Versioned)e.getValue()).value()));
    }

    @Override
    public void addIdToFreeList(Long id) {
        Preconditions.checkNotNull((Object)id, (Object)FREE_ID_NULL);
        this.freedIdList.add((Object)id);
    }

    @Override
    public void addVpnInsIfAbsent(String name, VpnInstance instance) {
        Preconditions.checkNotNull((Object)name, (Object)VPN_NAME_NULL);
        Preconditions.checkNotNull((Object)instance, (Object)VPN_INS_NULL);
        this.vpnInsMap.putIfAbsent((Object)name, (Object)instance);
    }

    @Override
    public void addVpnIns(String name, VpnInstance instance) {
        Preconditions.checkNotNull((Object)name, (Object)VPN_NAME_NULL);
        Preconditions.checkNotNull((Object)instance, (Object)VPN_INS_NULL);
        this.vpnInsMap.put((Object)name, (Object)instance);
    }

    @Override
    public void addInterfaceInfo(AccessInfo accessInfo, InterfaceInfo intInfo) {
        Preconditions.checkNotNull((Object)accessInfo, (Object)ACCESS_INFO_NULL);
        Preconditions.checkNotNull((Object)intInfo, (Object)INT_INFO_NULL);
        this.intInfoMap.put((Object)accessInfo, (Object)intInfo);
    }

    @Override
    public void addBgpInfo(BgpInfo bgpInfo, DeviceId devId) {
        Preconditions.checkNotNull((Object)devId, (Object)BGP_INFO_NULL);
        Preconditions.checkNotNull((Object)devId, (Object)DEV_ID_NULL);
        this.bgpInfoMap.put((Object)bgpInfo, (Object)devId);
    }

    @Override
    public boolean removeInterfaceInfo(AccessInfo accessInfo) {
        Preconditions.checkNotNull((Object)accessInfo, (Object)ACCESS_INFO_NULL);
        if (this.intInfoMap.remove((Object)accessInfo) == null) {
            this.log.error("Interface info deletion for access info {} has failed.", (Object)accessInfo.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeVpnInstance(String vpnName) {
        Preconditions.checkNotNull((Object)vpnName, (Object)VPN_NAME_NULL);
        if (this.vpnInsMap.remove((Object)vpnName) == null) {
            this.log.error("Vpn instance deletion for vpn name {} has failed.", (Object)vpnName);
            return false;
        }
        return true;
    }

    @Override
    public boolean removeIdFromFreeList(Long id) {
        Preconditions.checkNotNull((Object)id, (Object)FREE_ID_NULL);
        if (!this.freedIdList.remove((Object)id)) {
            this.log.error("Id from free id list {} deletion has failed.", (Object)id.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeBgpInfo(BgpInfo bgpInfo) {
        Preconditions.checkNotNull((Object)bgpInfo, (Object)BGP_INFO_NULL);
        if (this.bgpInfoMap.remove((Object)bgpInfo) == null) {
            this.log.error("Device id deletion for BGP info {} has failed.", (Object)bgpInfo.toString());
            return false;
        }
        return true;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

