/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.l3vpn.netl3vpn.impl;

import java.util.List;
import java.util.Map;
import org.onosproject.l3vpn.netl3vpn.AccessInfo;
import org.onosproject.l3vpn.netl3vpn.BgpInfo;
import org.onosproject.l3vpn.netl3vpn.DeviceInfo;
import org.onosproject.l3vpn.netl3vpn.NetL3VpnException;
import org.onosproject.l3vpn.netl3vpn.ProtocolInfo;
import org.onosproject.l3vpn.netl3vpn.RouteProtocol;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.RoutingProtocolType;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentipconnection.IpConnection;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.RoutingProtocol;

public final class BgpConstructionUtil {
    private static final String ZERO = "0";

    private BgpConstructionUtil() {
    }

    public static BgpInfo createBgpInfo(List<RoutingProtocol> routes, DeviceInfo info, String vpnName, IpConnection connect, AccessInfo access) {
        BgpInfo devBgp = info.bgpInfo();
        BgpInfo infoBgp = new BgpInfo();
        infoBgp.vpnName(vpnName);
        if (devBgp != null) {
            infoBgp = BgpConstructionUtil.updateDevBgpInfo(devBgp, infoBgp, connect, routes, access);
        } else {
            infoBgp = BgpConstructionUtil.updateDevBgpInfo(null, infoBgp, connect, routes, access);
            info.bgpInfo(infoBgp);
        }
        if (infoBgp == null || infoBgp.protocolInfo() == null) {
            return null;
        }
        return infoBgp;
    }

    private static BgpInfo updateDevBgpInfo(BgpInfo devBgp, BgpInfo driBgp, IpConnection connect, List<RoutingProtocol> routes, AccessInfo access) {
        for (RoutingProtocol route : routes) {
            ProtocolInfo ifInfo = BgpConstructionUtil.getRoutePro(route.type(), connect, access);
            if (ifInfo == null) continue;
            if (devBgp != null) {
                ProtocolInfo info = BgpConstructionUtil.addToDevBgp(ifInfo, devBgp, access);
                ifInfo = BgpConstructionUtil.getUpdatedProInfo(info, ifInfo);
            }
            if (ifInfo == null) continue;
            driBgp.addProtocolInfo(ifInfo.routeProtocol(), ifInfo);
        }
        return driBgp;
    }

    private static ProtocolInfo getUpdatedProInfo(ProtocolInfo devInfo, ProtocolInfo driInfo) {
        if (driInfo.isIpv4Af() && driInfo.isIpv6Af()) {
            if (BgpConstructionUtil.getV4Size(devInfo) > 1 && BgpConstructionUtil.getV6Size(devInfo) > 1) {
                return null;
            }
            if (BgpConstructionUtil.getV4Size(devInfo) > 1 && BgpConstructionUtil.getV6Size(devInfo) <= 1) {
                driInfo.ipv4Af(false);
            } else if (BgpConstructionUtil.getV4Size(devInfo) <= 1 && BgpConstructionUtil.getV6Size(devInfo) > 1) {
                driInfo.ipv6Af(false);
            }
        }
        if (driInfo.isIpv4Af() && !driInfo.isIpv6Af() && BgpConstructionUtil.getV4Size(devInfo) > 1) {
            return null;
        }
        if (!driInfo.isIpv4Af() && driInfo.isIpv6Af() && BgpConstructionUtil.getV6Size(devInfo) > 1) {
            return null;
        }
        return driInfo;
    }

    private static int getV4Size(ProtocolInfo proInfo) {
        return proInfo.v4Accesses().size();
    }

    private static int getV6Size(ProtocolInfo proInfo) {
        return proInfo.v6Accesses().size();
    }

    private static ProtocolInfo addToDevBgp(ProtocolInfo proInfo, BgpInfo devBgp, AccessInfo access) {
        Map<RouteProtocol, ProtocolInfo> devMap = devBgp.protocolInfo();
        ProtocolInfo devInfo = devMap.get((Object)proInfo.routeProtocol());
        if (devInfo != null) {
            if (proInfo.isIpv4Af()) {
                devInfo.ipv4Af(proInfo.isIpv4Af());
                devInfo.addV4Access(access);
            }
            if (proInfo.isIpv6Af()) {
                devInfo.ipv6Af(proInfo.isIpv6Af());
                devInfo.addV6Access(access);
            }
        } else {
            devInfo = proInfo;
            devBgp.addProtocolInfo(proInfo.routeProtocol(), devInfo);
        }
        return devInfo;
    }

    private static ProtocolInfo getRoutePro(Class<? extends RoutingProtocolType> type, IpConnection connect, AccessInfo access) {
        ProtocolInfo protocolInfo = new ProtocolInfo();
        RouteProtocol protocol = RouteProtocol.getProType(type.getSimpleName());
        switch (protocol) {
            case DIRECT: {
                protocolInfo.routeProtocol(RouteProtocol.DIRECT);
                protocolInfo.processId(ZERO);
                BgpConstructionUtil.setAddressFamily(protocolInfo, connect, access);
                return protocolInfo;
            }
            case STATIC: {
                protocolInfo.routeProtocol(RouteProtocol.STATIC);
                protocolInfo.processId(ZERO);
                BgpConstructionUtil.setAddressFamily(protocolInfo, connect, access);
                return protocolInfo;
            }
        }
        throw new NetL3VpnException(BgpConstructionUtil.getRouteProErr(type.getSimpleName()));
    }

    private static String getRouteProErr(String type) {
        return type + " routing protocol is not supported.";
    }

    private static void setAddressFamily(ProtocolInfo proInfo, IpConnection connect, AccessInfo access) {
        if (connect.ipv4() != null && connect.ipv4().addresses() != null && connect.ipv4().addresses().providerAddress() != null) {
            proInfo.ipv4Af(true);
            proInfo.addV4Access(access);
        }
        if (connect.ipv6() != null && connect.ipv6().addresses() != null && connect.ipv6().addresses().providerAddress() != null) {
            proInfo.ipv6Af(true);
            proInfo.addV6Access(access);
        }
    }
}

