/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.l3vpn.netl3vpn;

import java.util.LinkedList;
import java.util.List;
import org.onosproject.l3vpn.netl3vpn.AccessInfo;
import org.onosproject.l3vpn.netl3vpn.BgpDriverInfo;
import org.onosproject.l3vpn.netl3vpn.BgpInfo;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.L3VpnConfig;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.yang.model.ModelObjectData;

public class DeviceInfo {
    private final DeviceId deviceId;
    private BgpInfo bgpInfo;
    private List<String> ifNames;
    private List<AccessInfo> accesses;

    public DeviceInfo(DeviceId d) {
        this.deviceId = d;
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public void addIfName(String ifName) {
        if (this.ifNames == null) {
            this.ifNames = new LinkedList<String>();
        }
        this.ifNames.add(ifName);
    }

    public List<String> ifNames() {
        return this.ifNames;
    }

    public void ifNames(List<String> ifNames) {
        this.ifNames = ifNames;
    }

    public BgpInfo bgpInfo() {
        return this.bgpInfo;
    }

    public void bgpInfo(BgpInfo bgpInfo) {
        this.bgpInfo = bgpInfo;
    }

    public List<AccessInfo> accesses() {
        return this.accesses;
    }

    public void accesses(List<AccessInfo> accesses) {
        this.accesses = accesses;
    }

    public void addAccessInfo(AccessInfo accessInfo) {
        if (this.accesses == null) {
            this.accesses = new LinkedList<AccessInfo>();
        }
        this.accesses.add(accessInfo);
    }

    public ModelObjectData processCreateInstance(DriverService driverSvc, ModelObjectData modelData) {
        L3VpnConfig config = this.getL3VpnConfig(driverSvc);
        return (ModelObjectData)config.createInstance((Object)modelData);
    }

    public ModelObjectData processCreateInterface(DriverService driverSvc, ModelObjectData modData) {
        L3VpnConfig config = this.getL3VpnConfig(driverSvc);
        return (ModelObjectData)config.bindInterface((Object)modData);
    }

    public ModelObjectData processCreateBgpInfo(DriverService driverSvc, BgpInfo bgpInfo, BgpDriverInfo driverInfo) {
        L3VpnConfig config = this.getL3VpnConfig(driverSvc);
        return (ModelObjectData)config.createBgpInfo((Object)bgpInfo, (Object)driverInfo);
    }

    public ModelObjectData processDeleteInstance(DriverService driverSvc, ModelObjectData modData) {
        L3VpnConfig config = this.getL3VpnConfig(driverSvc);
        return (ModelObjectData)config.deleteInstance((Object)modData);
    }

    public ModelObjectData processDeleteInterface(DriverService driverSvc, ModelObjectData objectData) {
        return null;
    }

    public ModelObjectData processDeleteBgpInfo(DriverService driverSvc, BgpInfo bgpInfo, BgpDriverInfo driverInfo) {
        L3VpnConfig config = this.getL3VpnConfig(driverSvc);
        return (ModelObjectData)config.deleteBgpInfo((Object)bgpInfo, (Object)driverInfo);
    }

    private L3VpnConfig getL3VpnConfig(DriverService driverSvc) {
        DriverHandler handler = driverSvc.createHandler(this.deviceId, new String[0]);
        return (L3VpnConfig)handler.behaviour(L3VpnConfig.class);
    }
}

