/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.bgp.cfg.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onosproject.bgp.controller.BgpCfg;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpAppConfig
extends Config<ApplicationId> {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    BgpController bgpController;
    BgpCfg bgpConfig = null;
    protected final Logger log = LoggerFactory.getLogger(BgpAppConfig.class);
    public static final String ROUTER_ID = "routerId";
    public static final String LOCAL_AS = "localAs";
    public static final String MAX_SESSION = "maxSession";
    public static final String LS_CAPABILITY = "lsCapability";
    public static final String HOLD_TIME = "holdTime";
    public static final String LARGE_AS_CAPABILITY = "largeAsCapability";
    public static final String FLOW_SPEC_CAPABILITY = "flowSpecCapability";
    public static final String FLOW_SPEC_RPD_CAPABILITY = "flowSpecRpdCapability";
    public static final String BGP_PEER = "bgpPeer";
    public static final String PEER_IP = "peerIp";
    public static final String REMOTE_AS = "remoteAs";
    public static final String PEER_HOLD_TIME = "peerHoldTime";
    public static final String PEER_CONNECT_MODE = "connectMode";
    public static final String PEER_CONNECT_PASSIVE = "passive";
    public static final String PEER_CONNECT_ACTIVE = "active";
    static final int MAX_SHORT_AS_NUMBER = 65535;
    static final long MAX_LONG_AS_NUMBER = 0xFFFFFFFFL;
    static final int MIN_SESSION_NUMBER = 1;
    static final long MAX_SESSION_NUMBER = 21L;
    static final int MIN_HOLDTIME = 0;
    static final long MAX_HOLDTIME = 65535L;

    public boolean isValid() {
        boolean fields = false;
        this.bgpController = (BgpController)DefaultServiceDirectory.getService(BgpController.class);
        this.bgpConfig = this.bgpController.getConfig();
        boolean bl = fields = this.hasOnlyFields(new String[]{ROUTER_ID, LOCAL_AS, MAX_SESSION, LS_CAPABILITY, HOLD_TIME, LARGE_AS_CAPABILITY, FLOW_SPEC_CAPABILITY, FLOW_SPEC_RPD_CAPABILITY, BGP_PEER}) && this.isIpAddress(ROUTER_ID, Config.FieldPresence.MANDATORY) && this.isNumber(LOCAL_AS, Config.FieldPresence.MANDATORY, new long[0]) && this.isNumber(MAX_SESSION, Config.FieldPresence.OPTIONAL, new long[]{1L, 21L}) && this.isNumber(HOLD_TIME, Config.FieldPresence.OPTIONAL, new long[]{0L, 65535L}) && this.isBoolean(LS_CAPABILITY, Config.FieldPresence.OPTIONAL) && this.isBoolean(LARGE_AS_CAPABILITY, Config.FieldPresence.OPTIONAL) && this.isString(FLOW_SPEC_CAPABILITY, Config.FieldPresence.OPTIONAL, new String[0]) && this.isBoolean(FLOW_SPEC_RPD_CAPABILITY, Config.FieldPresence.OPTIONAL);
        if (!fields) {
            return fields;
        }
        return this.validateBgpConfiguration();
    }

    public String routerId() {
        return this.get(ROUTER_ID, null);
    }

    public int localAs() {
        return Integer.parseInt(this.get(LOCAL_AS, null));
    }

    public int maxSession() {
        return Integer.parseInt(this.get(MAX_SESSION, null));
    }

    public boolean lsCapability() {
        return Boolean.parseBoolean(this.get(LS_CAPABILITY, null));
    }

    public boolean rpdCapability() {
        return Boolean.parseBoolean(this.get(FLOW_SPEC_RPD_CAPABILITY, null));
    }

    public boolean largeAsCapability() {
        return Boolean.parseBoolean(this.get(LARGE_AS_CAPABILITY, null));
    }

    public String flowSpecCapability() {
        return this.get(FLOW_SPEC_CAPABILITY, null);
    }

    public short holdTime() {
        return Short.parseShort(this.get(HOLD_TIME, null));
    }

    public boolean validateFlowSpec() {
        String flowSpec;
        if (!(this.flowSpecCapability() == null || (flowSpec = this.flowSpecCapability()).equals("IPV4") || flowSpec.equals("VPNV4") || flowSpec.equals("IPV4_VPNV4"))) {
            this.log.debug("Flow specification capabality is false");
            return false;
        }
        this.log.debug("Flow specification capabality is true");
        return true;
    }

    public boolean validateHoldTime() {
        short holdTime;
        return this.holdTime() == 0 || (holdTime = this.holdTime()) != 1 && holdTime != 2;
    }

    public boolean validateBgpConfiguration() {
        if (!this.validateLocalAs()) {
            return false;
        }
        if (!this.validateRouterId()) {
            return false;
        }
        if (!this.validateBgpPeers()) {
            return false;
        }
        if (!this.validateFlowSpec()) {
            return false;
        }
        return this.validateHoldTime();
    }

    public boolean validateLocalAs() {
        long localAs = 0L;
        localAs = this.localAs();
        return !(this.largeAsCapability() ? localAs == 0L || localAs >= 0xFFFFFFFFL : localAs == 0L || localAs >= 65535L);
    }

    public boolean validateRemoteAs(long remoteAs) {
        return !(this.largeAsCapability() ? remoteAs == 0L || remoteAs >= 0xFFFFFFFFL : remoteAs == 0L || remoteAs >= 65535L);
    }

    public boolean validateRouterId() {
        String routerId = this.routerId();
        return true;
    }

    public boolean validatePeerHoldTime(long remoteAs) {
        return true;
    }

    public boolean validateBgpPeers() {
        List<BgpPeerConfig> nodes = this.bgpPeer();
        for (int i = 0; i < nodes.size(); ++i) {
            String connectMode = nodes.get(i).connectMode();
            if (IpAddress.valueOf((String)nodes.get(i).hostname()) != null && this.validateRemoteAs(nodes.get(i).asNumber()) && this.validatePeerHoldTime(nodes.get(i).holdTime()) && (connectMode.equals(PEER_CONNECT_ACTIVE) || connectMode.equals(PEER_CONNECT_PASSIVE))) continue;
            this.log.debug("BGP peer configration false");
            return false;
        }
        this.log.debug("BGP peer configration true");
        return true;
    }

    public List<BgpPeerConfig> bgpPeer() {
        ArrayList<BgpPeerConfig> nodes = new ArrayList<BgpPeerConfig>();
        JsonNode jsonNodes = this.object.get(BGP_PEER);
        if (jsonNodes == null) {
            return null;
        }
        jsonNodes.forEach(jsonNode -> nodes.add(new BgpPeerConfig(jsonNode.path(PEER_IP).asText(), jsonNode.path(REMOTE_AS).asInt(), jsonNode.path(PEER_HOLD_TIME).asInt(), jsonNode.path(PEER_CONNECT_MODE).asText())));
        return nodes;
    }

    public static class BgpPeerConfig {
        private final String hostname;
        private final int asNumber;
        private final short holdTime;
        private final String connectMode;

        public BgpPeerConfig(String hostname, int asNumber, int holdTime, String connectMode) {
            this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
            this.asNumber = asNumber;
            this.holdTime = (short)holdTime;
            this.connectMode = connectMode;
        }

        public String hostname() {
            return this.hostname;
        }

        public int asNumber() {
            return this.asNumber;
        }

        public short holdTime() {
            return this.holdTime;
        }

        public String connectMode() {
            return this.connectMode;
        }
    }
}

