/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.fnl.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.onlab.packet.EthType;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.fnl.base.TsReturn;
import org.onosproject.fnl.intf.NetworkAnomaly;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPDscpCriterion;
import org.onosproject.net.flow.criteria.IPEcnCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.TcpPortCriterion;
import org.onosproject.net.flow.criteria.UdpPortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.criteria.VlanPcpCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TsLoopPacket
implements NetworkAnomaly {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String EOL = String.format("%n", new Object[0]);
    private static final String LINE = EOL + "====================================================" + EOL;
    private static final String HDR_FMT = EOL + "---------- %s ----------" + EOL;
    private static final String LOOP_HEADER = TsLoopPacket.makeHeader("Loop Header");
    private static final String LOOP_FLOW_ENTRIES = TsLoopPacket.makeHeader("Loop Flow Entries");
    private static final String LOOP_LINKS = TsLoopPacket.makeHeader("Loop Links");
    private Map<Criterion.Type, Criterion> match = new HashMap<Criterion.Type, Criterion>();
    private Stack<FlowEntry> pathFlow = new Stack();
    private Stack<Link> pathLink = new Stack();

    private TsLoopPacket() {
    }

    @Override
    public NetworkAnomaly.Type type() {
        return NetworkAnomaly.Type.LOOP;
    }

    public TsLoopPacket copyPacketMatch() {
        TsLoopPacket newOne = new TsLoopPacket();
        newOne.pathFlow = this.pathFlow;
        newOne.pathLink = this.pathLink;
        Map<Criterion.Type, Criterion> m = newOne.match;
        block17: for (Map.Entry<Criterion.Type, Criterion> entry : this.match.entrySet()) {
            Criterion.Type k = entry.getKey();
            Criterion v = entry.getValue();
            switch (k) {
                case IN_PORT: {
                    m.put(k, Criteria.matchInPort((PortNumber)((PortCriterion)v).port()));
                    continue block17;
                }
                case ETH_SRC: {
                    m.put(k, Criteria.matchEthSrc((MacAddress)((EthCriterion)v).mac()));
                    continue block17;
                }
                case ETH_DST: {
                    m.put(k, Criteria.matchEthDst((MacAddress)((EthCriterion)v).mac()));
                    continue block17;
                }
                case ETH_TYPE: {
                    m.put(k, Criteria.matchEthType((EthType)((EthTypeCriterion)v).ethType()));
                    continue block17;
                }
                case VLAN_VID: {
                    m.put(k, Criteria.matchVlanId((VlanId)((VlanIdCriterion)v).vlanId()));
                    continue block17;
                }
                case VLAN_PCP: {
                    m.put(k, Criteria.matchVlanPcp((byte)((VlanPcpCriterion)v).priority()));
                    continue block17;
                }
                case IPV4_SRC: {
                    m.put(k, Criteria.matchIPSrc((IpPrefix)((IPCriterion)v).ip()));
                    continue block17;
                }
                case IPV4_DST: {
                    m.put(k, Criteria.matchIPDst((IpPrefix)((IPCriterion)v).ip()));
                    continue block17;
                }
                case IP_PROTO: {
                    m.put(k, Criteria.matchIPProtocol((short)((IPProtocolCriterion)v).protocol()));
                    continue block17;
                }
                case IP_DSCP: {
                    m.put(k, Criteria.matchIPDscp((byte)((IPDscpCriterion)v).ipDscp()));
                    continue block17;
                }
                case IP_ECN: {
                    m.put(k, Criteria.matchIPEcn((byte)((IPEcnCriterion)v).ipEcn()));
                    continue block17;
                }
                case TCP_SRC: {
                    m.put(k, Criteria.matchTcpSrc((TpPort)((TcpPortCriterion)v).tcpPort()));
                    continue block17;
                }
                case TCP_DST: {
                    m.put(k, Criteria.matchTcpDst((TpPort)((TcpPortCriterion)v).tcpPort()));
                    continue block17;
                }
                case UDP_SRC: {
                    m.put(k, Criteria.matchUdpSrc((TpPort)((UdpPortCriterion)v).udpPort()));
                    continue block17;
                }
                case UDP_DST: {
                    m.put(k, Criteria.matchUdpDst((TpPort)((UdpPortCriterion)v).udpPort()));
                    continue block17;
                }
            }
            this.log.debug("{} can't be supported by OF1.0", (Object)k);
        }
        return newOne;
    }

    public SetHeaderResult setHeader(Criterion criterion) {
        if (criterion == null) {
            return SetHeaderResult.SETHEADER_FAILURE_NULL;
        }
        boolean hasKey = this.match.containsKey(criterion.type());
        this.match.put(criterion.type(), criterion);
        return hasKey ? SetHeaderResult.SETHEADER_OVERRIDE : SetHeaderResult.SETHEADER_SUCCESS;
    }

    public boolean delHeader(Criterion.Type criterionType) {
        return this.match.remove(criterionType) != null;
    }

    public Criterion getHeader(Criterion.Type criterionType) {
        return this.match.get(criterionType);
    }

    public boolean headerExists(Criterion.Type criterionType) {
        return this.match.containsKey(criterionType);
    }

    public void pushPathFlow(FlowEntry entry) {
        this.pathFlow.push(entry);
    }

    public void popPathFlow() {
        this.pathFlow.pop();
    }

    public Iterator<Link> getPathLink() {
        return this.pathLink.iterator();
    }

    public void pushPathLink(Link link) {
        this.pathLink.push(link);
    }

    public void popPathLink() {
        this.pathLink.pop();
    }

    public boolean isPassedDevice(DeviceId deviceId) {
        for (Link linkTemp : this.pathLink) {
            if (!deviceId.equals((Object)linkTemp.src().deviceId())) continue;
            return true;
        }
        return false;
    }

    public PortCriterion getInport() {
        return (PortCriterion)this.match.get(Criterion.Type.IN_PORT);
    }

    public static TsLoopPacket matchBuilder(Iterable<Criterion> criteria, TsReturn<Boolean> collision) {
        if (null != collision) {
            collision.setValue(false);
        }
        TsLoopPacket pkt = new TsLoopPacket();
        for (Criterion criterion : criteria) {
            SetHeaderResult ret = pkt.setHeader(criterion);
            if (SetHeaderResult.SETHEADER_SUCCESS == ret) continue;
            if (SetHeaderResult.SETHEADER_OVERRIDE == ret) {
                if (null == collision) continue;
                collision.setValue(true);
                continue;
            }
            pkt = null;
            break;
        }
        return pkt;
    }

    public void handInLoopMatch(TsLoopPacket loopPkt) {
        this.match = loopPkt.match;
    }

    public void resetLinkFlow(FlowEntry firstEntry) {
        this.pathLink = new Stack();
        this.pathFlow = new Stack();
        this.pathFlow.push(firstEntry);
    }

    private static String makeHeader(String title) {
        return String.format(HDR_FMT, title);
    }

    public String toString() {
        StringBuilder me = new StringBuilder();
        me.append(LINE);
        me.append(LOOP_HEADER);
        ArrayList<Criterion> criteria = new ArrayList<Criterion>(this.match.values());
        Collections.sort(criteria, (o1, o2) -> o1.type().compareTo((Enum)o2.type()));
        for (Criterion c : criteria) {
            me.append(c).append(EOL);
        }
        me.append(LOOP_FLOW_ENTRIES);
        for (FlowEntry flow : this.pathFlow) {
            me.append(flow).append(EOL);
        }
        me.append(LOOP_LINKS);
        for (Link l : this.pathLink) {
            me.append(l).append(EOL);
        }
        return me.toString();
    }

    public static enum SetHeaderResult {
        SETHEADER_SUCCESS,
        SETHEADER_OVERRIDE,
        SETHEADER_FAILURE_NULL,
        SETHEADER_FAILURE;

    }
}

