/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.fnl.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.criteria.Criterion;

public final class NetworkDiagnosticUtils {
    private NetworkDiagnosticUtils() {
    }

    public static List<FlowEntry> sortFlowTable(Iterable<FlowEntry> flowEntries) {
        ArrayList<FlowEntry> flows = new ArrayList<FlowEntry>();
        flowEntries.forEach(flows::add);
        Collections.sort(flows, (f1, f2) -> f2.priority() - f1.priority());
        return flows;
    }

    public static List<Criterion> sortCriteria(Set<Criterion> criterionSet) {
        ArrayList<Criterion> array = new ArrayList<Criterion>(criterionSet);
        Collections.sort(array, (c1, c2) -> c1.type().compareTo((Enum)c2.type()));
        return array;
    }

    public static boolean isDevice(ConnectPoint connectPoint) {
        return connectPoint.elementId() instanceof DeviceId;
    }

    public static boolean isHost(ConnectPoint connectPoint) {
        return connectPoint.elementId() instanceof HostId;
    }
}

