/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.orgopenroadmethernetinterfaces.rev20161014.orgopenroadmethernetinterfaces.ethernetcontainer;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.orgopenroadmethernetinterfaces.rev20161014.orgopenroadmethernetinterfaces.ethattributes.AutoNegotiationEnum;
import org.onosproject.yang.gen.v1.orgopenroadmethernetinterfaces.rev20161014.orgopenroadmethernetinterfaces.ethattributes.DuplexEnum;
import org.onosproject.yang.gen.v1.orgopenroadmethernetinterfaces.rev20161014.orgopenroadmethernetinterfaces.ethattributes.FecEnum;
import org.onosproject.yang.gen.v1.orgopenroadmethernetinterfaces.rev20161014.orgopenroadmethernetinterfaces.ethernetcontainer.Ethernet;
import org.onosproject.yang.model.InnerModelObject;

public class DefaultEthernet
extends InnerModelObject
implements Ethernet {
    protected long speed;
    protected FecEnum fec;
    protected DuplexEnum duplex;
    protected long mtu;
    protected AutoNegotiationEnum autoNegotiation;
    protected String currSpeed;
    protected String currDuplex;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public long speed() {
        return this.speed;
    }

    @Override
    public FecEnum fec() {
        return this.fec;
    }

    @Override
    public DuplexEnum duplex() {
        return this.duplex;
    }

    @Override
    public long mtu() {
        return this.mtu;
    }

    @Override
    public AutoNegotiationEnum autoNegotiation() {
        return this.autoNegotiation;
    }

    @Override
    public String currSpeed() {
        return this.currSpeed;
    }

    @Override
    public String currDuplex() {
        return this.currDuplex;
    }

    @Override
    public BitSet valueLeafFlags() {
        return this.valueLeafFlags;
    }

    @Override
    public void speed(long speed) {
        this.valueLeafFlags.set(Ethernet.LeafIdentifier.SPEED.getLeafIndex());
        this.speed = speed;
    }

    @Override
    public void fec(FecEnum fec) {
        this.valueLeafFlags.set(Ethernet.LeafIdentifier.FEC.getLeafIndex());
        this.fec = fec;
    }

    @Override
    public void duplex(DuplexEnum duplex) {
        this.valueLeafFlags.set(Ethernet.LeafIdentifier.DUPLEX.getLeafIndex());
        this.duplex = duplex;
    }

    @Override
    public void mtu(long mtu) {
        this.valueLeafFlags.set(Ethernet.LeafIdentifier.MTU.getLeafIndex());
        this.mtu = mtu;
    }

    @Override
    public void autoNegotiation(AutoNegotiationEnum autoNegotiation) {
        this.valueLeafFlags.set(Ethernet.LeafIdentifier.AUTONEGOTIATION.getLeafIndex());
        this.autoNegotiation = autoNegotiation;
    }

    @Override
    public void currSpeed(String currSpeed) {
        this.valueLeafFlags.set(Ethernet.LeafIdentifier.CURRSPEED.getLeafIndex());
        this.currSpeed = currSpeed;
    }

    @Override
    public void currDuplex(String currDuplex) {
        this.valueLeafFlags.set(Ethernet.LeafIdentifier.CURRDUPLEX.getLeafIndex());
        this.currDuplex = currDuplex;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.speed, this.fec, this.duplex, this.mtu, this.autoNegotiation, this.currSpeed, this.currDuplex, this.valueLeafFlags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultEthernet) {
            DefaultEthernet other = (DefaultEthernet)obj;
            return Objects.equals(this.speed, other.speed) && Objects.equals((Object)this.fec, (Object)other.fec) && Objects.equals((Object)this.duplex, (Object)other.duplex) && Objects.equals(this.mtu, other.mtu) && Objects.equals((Object)this.autoNegotiation, (Object)other.autoNegotiation) && Objects.equals(this.currSpeed, other.currSpeed) && Objects.equals(this.currDuplex, other.currDuplex) && Objects.equals(this.valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("speed=" + this.speed).add("fec=" + (Object)((Object)this.fec)).add("duplex=" + (Object)((Object)this.duplex)).add("mtu=" + this.mtu).add("autoNegotiation=" + (Object)((Object)this.autoNegotiation)).add("currSpeed=" + this.currSpeed).add("currDuplex=" + this.currDuplex).add("valueLeafFlags=" + this.valueLeafFlags).toString();
    }

    @Override
    public boolean isLeafValueSet(Ethernet.LeafIdentifier leaf) {
        return this.valueLeafFlags.get(leaf.getLeafIndex());
    }
}

