/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.orgopenroadmdevice.rev20170206.orgopenroadmdevice.startscan;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.orgopenroadmcommontypes.rev20161014.orgopenroadmcommontypes.Direction;
import org.onosproject.yang.gen.v1.orgopenroadmdevice.rev20170206.orgopenroadmdevice.startscan.StartScanInput;
import org.onosproject.yang.model.InnerModelObject;

public class DefaultStartScanInput
extends InnerModelObject
implements StartScanInput {
    protected int degreeNumber;
    protected Direction portDirection;
    protected long distance;
    protected long resolution;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public int degreeNumber() {
        return this.degreeNumber;
    }

    @Override
    public Direction portDirection() {
        return this.portDirection;
    }

    @Override
    public long distance() {
        return this.distance;
    }

    @Override
    public long resolution() {
        return this.resolution;
    }

    @Override
    public BitSet valueLeafFlags() {
        return this.valueLeafFlags;
    }

    @Override
    public void degreeNumber(int degreeNumber) {
        this.valueLeafFlags.set(StartScanInput.LeafIdentifier.DEGREENUMBER.getLeafIndex());
        this.degreeNumber = degreeNumber;
    }

    @Override
    public void portDirection(Direction portDirection) {
        this.valueLeafFlags.set(StartScanInput.LeafIdentifier.PORTDIRECTION.getLeafIndex());
        this.portDirection = portDirection;
    }

    @Override
    public void distance(long distance) {
        this.valueLeafFlags.set(StartScanInput.LeafIdentifier.DISTANCE.getLeafIndex());
        this.distance = distance;
    }

    @Override
    public void resolution(long resolution) {
        this.valueLeafFlags.set(StartScanInput.LeafIdentifier.RESOLUTION.getLeafIndex());
        this.resolution = resolution;
    }

    public int hashCode() {
        return Objects.hash(this.degreeNumber, this.portDirection, this.distance, this.resolution, this.valueLeafFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultStartScanInput) {
            DefaultStartScanInput other = (DefaultStartScanInput)obj;
            return Objects.equals(this.degreeNumber, other.degreeNumber) && Objects.equals(this.portDirection, other.portDirection) && Objects.equals(this.distance, other.distance) && Objects.equals(this.resolution, other.resolution) && Objects.equals(this.valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("degreeNumber=" + this.degreeNumber).add("portDirection=" + this.portDirection).add("distance=" + this.distance).add("resolution=" + this.resolution).add("valueLeafFlags=" + this.valueLeafFlags).toString();
    }

    @Override
    public boolean isLeafValueSet(StartScanInput.LeafIdentifier leaf) {
        return this.valueLeafFlags.get(leaf.getLeafIndex());
    }
}

