/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.ietfnetconf.rev20110601.ietfnetconf.commit;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfnetconf.rev20110601.ietfnetconf.commit.CommitInput;
import org.onosproject.yang.model.InnerModelObject;

public class DefaultCommitInput
extends InnerModelObject
implements CommitInput {
    protected boolean confirmed;
    protected long confirmTimeout;
    protected String persist;
    protected String persistId;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public boolean confirmed() {
        return this.confirmed;
    }

    @Override
    public long confirmTimeout() {
        return this.confirmTimeout;
    }

    @Override
    public String persist() {
        return this.persist;
    }

    @Override
    public String persistId() {
        return this.persistId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return this.valueLeafFlags;
    }

    @Override
    public void confirmed(boolean confirmed) {
        this.valueLeafFlags.set(CommitInput.LeafIdentifier.CONFIRMED.getLeafIndex());
        this.confirmed = confirmed;
    }

    @Override
    public void confirmTimeout(long confirmTimeout) {
        this.valueLeafFlags.set(CommitInput.LeafIdentifier.CONFIRMTIMEOUT.getLeafIndex());
        this.confirmTimeout = confirmTimeout;
    }

    @Override
    public void persist(String persist) {
        this.valueLeafFlags.set(CommitInput.LeafIdentifier.PERSIST.getLeafIndex());
        this.persist = persist;
    }

    @Override
    public void persistId(String persistId) {
        this.valueLeafFlags.set(CommitInput.LeafIdentifier.PERSISTID.getLeafIndex());
        this.persistId = persistId;
    }

    public int hashCode() {
        return Objects.hash(this.confirmed, this.confirmTimeout, this.persist, this.persistId, this.valueLeafFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCommitInput) {
            DefaultCommitInput other = (DefaultCommitInput)obj;
            return Objects.equals(this.confirmed, other.confirmed) && Objects.equals(this.confirmTimeout, other.confirmTimeout) && Objects.equals(this.persist, other.persist) && Objects.equals(this.persistId, other.persistId) && Objects.equals(this.valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("confirmed=" + this.confirmed).add("confirmTimeout=" + this.confirmTimeout).add("persist=" + this.persist).add("persistId=" + this.persistId).add("valueLeafFlags=" + this.valueLeafFlags).toString();
    }

    @Override
    public boolean isLeafValueSet(CommitInput.LeafIdentifier leaf) {
        return this.valueLeafFlags.get(leaf.getLeafIndex());
    }
}

