/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.ietfinettypes.rev20130715.ietfinettypes.ipprefix;

import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.gen.v1.ietfinettypes.rev20130715.ietfinettypes.Ipv4Prefix;
import org.onosproject.yang.gen.v1.ietfinettypes.rev20130715.ietfinettypes.Ipv6Prefix;

public final class IpPrefixUnion {
    private Ipv4Prefix ipv4Prefix;
    private Ipv6Prefix ipv6Prefix;
    private BitSet setValue = new BitSet();

    private IpPrefixUnion() {
    }

    public IpPrefixUnion(Ipv4Prefix ipv4Prefix) {
        this.setValue.set(0);
        this.ipv4Prefix = ipv4Prefix;
    }

    public IpPrefixUnion(Ipv6Prefix ipv6Prefix) {
        this.setValue.set(1);
        this.ipv6Prefix = ipv6Prefix;
    }

    public static IpPrefixUnion of(Ipv4Prefix value) {
        return new IpPrefixUnion(value);
    }

    public static IpPrefixUnion of(Ipv6Prefix value) {
        return new IpPrefixUnion(value);
    }

    public Ipv4Prefix ipv4Prefix() {
        return this.ipv4Prefix;
    }

    public Ipv6Prefix ipv6Prefix() {
        return this.ipv6Prefix;
    }

    public void ipv4Prefix(Ipv4Prefix ipv4Prefix) {
        this.ipv4Prefix = ipv4Prefix;
    }

    public void ipv6Prefix(Ipv6Prefix ipv6Prefix) {
        this.ipv6Prefix = ipv6Prefix;
    }

    public int hashCode() {
        return Objects.hash(this.ipv4Prefix, this.ipv6Prefix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IpPrefixUnion) {
            IpPrefixUnion other = (IpPrefixUnion)obj;
            return Objects.equals(this.ipv4Prefix, other.ipv4Prefix) && Objects.equals(this.ipv6Prefix, other.ipv6Prefix);
        }
        return false;
    }

    public String toString() {
        if (this.setValue.get(0)) {
            return this.ipv4Prefix.toString();
        }
        if (this.setValue.get(1)) {
            return this.ipv6Prefix.toString();
        }
        return null;
    }

    public static IpPrefixUnion fromString(String valInString) {
        try {
            Ipv4Prefix tmpVal = Ipv4Prefix.fromString(valInString);
            return IpPrefixUnion.of(tmpVal);
        }
        catch (Exception tmpVal) {
            try {
                Ipv6Prefix tmpVal2 = Ipv6Prefix.fromString(valInString);
                return IpPrefixUnion.of(tmpVal2);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("not a valid input element");
            }
        }
    }
}

