/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.metrics.topology.cli;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.commands.Command;
import org.onlab.metrics.EventMetric;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.metrics.topology.TopologyMetricsService;

@Command(scope="onos", name="topology-events-metrics", description="Lists topology events metrics")
public class TopologyEventsMetricsCommand
extends AbstractShellCommand {
    private static final String FORMAT_GAUGE = "Topology %s Event Timestamp (ms from epoch)=%d";
    private static final String FORMAT_METER = "Topology %s Events count=%d rate(events/sec) mean=%f m1=%f m5=%f m15=%f";

    protected void execute() {
        TopologyMetricsService service = (TopologyMetricsService)TopologyEventsMetricsCommand.get(TopologyMetricsService.class);
        if (this.outputJson()) {
            ObjectMapper mapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
            ObjectNode result = mapper.createObjectNode();
            result = this.json(mapper, result, "topologyDeviceEvent", service.topologyDeviceEventMetric());
            result = this.json(mapper, result, "topologyHostEvent", service.topologyHostEventMetric());
            result = this.json(mapper, result, "topologyLinkEvent", service.topologyLinkEventMetric());
            result = this.json(mapper, result, "topologyGraphEvent", service.topologyGraphEventMetric());
            result = this.json(mapper, result, "topologyGraphReasonsEvent", service.topologyGraphReasonsEventMetric());
            this.print("%s", new Object[]{result});
        } else {
            this.printEventMetric("Device", service.topologyDeviceEventMetric());
            this.printEventMetric("Host", service.topologyHostEventMetric());
            this.printEventMetric("Link", service.topologyLinkEventMetric());
            this.printEventMetric("Graph", service.topologyGraphEventMetric());
            this.printEventMetric("Graph Reasons", service.topologyGraphReasonsEventMetric());
        }
    }

    private ObjectNode json(ObjectMapper mapper, ObjectNode objectNode, String propertyPrefix, EventMetric eventMetric) {
        String gaugeName = propertyPrefix + "Timestamp";
        String meterName = propertyPrefix + "Rate";
        Gauge gauge = eventMetric.lastEventTimestampGauge();
        Meter meter = eventMetric.eventRateMeter();
        objectNode.set(gaugeName, this.json(mapper, gauge));
        objectNode.set(meterName, this.json(mapper, meter));
        return objectNode;
    }

    private JsonNode json(ObjectMapper mapper, Object object) {
        try {
            String objectJson = mapper.writeValueAsString(object);
            JsonNode jsonNode = mapper.readTree(objectJson);
            return jsonNode;
        }
        catch (JsonProcessingException e) {
            this.log.error("Error writing value as JSON string", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Error writing value as JSON string", (Throwable)e);
        }
        return null;
    }

    private void printEventMetric(String operationStr, EventMetric eventMetric) {
        Gauge gauge = eventMetric.lastEventTimestampGauge();
        Meter meter = eventMetric.eventRateMeter();
        TimeUnit rateUnit = TimeUnit.SECONDS;
        double rateFactor = rateUnit.toSeconds(1L);
        this.print(FORMAT_GAUGE, new Object[]{operationStr, gauge.getValue()});
        this.print(FORMAT_METER, new Object[]{operationStr, meter.getCount(), meter.getMeanRate() * rateFactor, meter.getOneMinuteRate() * rateFactor, meter.getFiveMinuteRate() * rateFactor, meter.getFifteenMinuteRate() * rateFactor});
    }
}

