/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.metrics.topology.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.event.Event;
import org.onosproject.metrics.topology.TopologyMetricsService;
import org.onosproject.net.topology.TopologyEvent;

@Command(scope="onos", name="topology-events", description="Lists the last topology events")
public class TopologyEventsListCommand
extends AbstractShellCommand {
    private static final String FORMAT_EVENT = "Event=%s";
    private static final String FORMAT_REASON = "    Reason=%s";

    protected void execute() {
        TopologyMetricsService service = (TopologyMetricsService)TopologyEventsListCommand.get(TopologyMetricsService.class);
        if (this.outputJson()) {
            this.print("%s", new Object[]{this.json(service.getEvents())});
        } else {
            for (Event event : service.getEvents()) {
                this.print(FORMAT_EVENT, new Object[]{event});
                if (event instanceof TopologyEvent) {
                    TopologyEvent topologyEvent = (TopologyEvent)event;
                    for (Event reason : topologyEvent.reasons()) {
                        this.print(FORMAT_REASON, new Object[]{reason});
                    }
                }
                this.print("", new Object[0]);
            }
        }
    }

    private JsonNode json(List<Event> events) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Event event : events) {
            result.add((JsonNode)this.json(mapper, event));
        }
        return result;
    }

    private ObjectNode json(ObjectMapper mapper, Event event) {
        ObjectNode result = mapper.createObjectNode();
        result.put("time", event.time()).put("type", event.type().toString()).put("event", event.toString());
        if (event instanceof TopologyEvent) {
            TopologyEvent topologyEvent = (TopologyEvent)event;
            ArrayNode reasons = mapper.createArrayNode();
            for (Event reason : topologyEvent.reasons()) {
                reasons.add((JsonNode)this.json(mapper, reason));
            }
            result.set("reasons", (JsonNode)reasons);
        }
        return result;
    }
}

