/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.metrics.intent;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.metrics.EventMetric;
import org.onlab.metrics.MetricsService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.metrics.intent.IntentMetricsService;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class IntentMetrics
implements IntentMetricsService,
IntentListener {
    private static final Logger log = LoggerFactory.getLogger(IntentMetrics.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    private ApplicationId appId;
    private LinkedList<IntentEvent> lastEvents = new LinkedList();
    private static final int LAST_EVENTS_MAX_N = 100;
    private static final String COMPONENT_NAME = "Intent";
    private static final String FEATURE_SUBMITTED_NAME = "Submitted";
    private static final String FEATURE_INSTALLED_NAME = "Installed";
    private static final String FEATURE_FAILED_NAME = "Failed";
    private static final String FEATURE_WITHDRAW_REQUESTED_NAME = "WithdrawRequested";
    private static final String FEATURE_WITHDRAWN_NAME = "Withdrawn";
    private static final String FEATURE_PURGED_NAME = "Purged";
    private EventMetric intentSubmittedEventMetric;
    private EventMetric intentInstalledEventMetric;
    private EventMetric intentFailedEventMetric;
    private EventMetric intentWithdrawRequestedEventMetric;
    private EventMetric intentWithdrawnEventMetric;
    private EventMetric intentPurgedEventMetric;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.metrics");
        this.clear();
        this.registerMetrics();
        this.intentService.addListener((EventListener)this);
        log.info("Started with Application ID {}", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.intentService.removeListener((EventListener)this);
        this.removeMetrics();
        this.clear();
        log.info("Stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IntentEvent> getEvents() {
        LinkedList<IntentEvent> linkedList = this.lastEvents;
        synchronized (linkedList) {
            return ImmutableList.copyOf(this.lastEvents);
        }
    }

    @Override
    public EventMetric intentSubmittedEventMetric() {
        return this.intentSubmittedEventMetric;
    }

    @Override
    public EventMetric intentInstalledEventMetric() {
        return this.intentInstalledEventMetric;
    }

    @Override
    public EventMetric intentFailedEventMetric() {
        return this.intentFailedEventMetric;
    }

    @Override
    public EventMetric intentWithdrawRequestedEventMetric() {
        return this.intentWithdrawRequestedEventMetric;
    }

    @Override
    public EventMetric intentWithdrawnEventMetric() {
        return this.intentWithdrawnEventMetric;
    }

    @Override
    public EventMetric intentPurgedEventMetric() {
        return this.intentPurgedEventMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(IntentEvent event) {
        LinkedList<IntentEvent> linkedList = this.lastEvents;
        synchronized (linkedList) {
            switch ((IntentEvent.Type)event.type()) {
                case INSTALL_REQ: {
                    this.intentSubmittedEventMetric.eventReceived();
                    break;
                }
                case INSTALLED: {
                    this.intentInstalledEventMetric.eventReceived();
                    break;
                }
                case FAILED: {
                    this.intentFailedEventMetric.eventReceived();
                    break;
                }
                case WITHDRAW_REQ: {
                    this.intentWithdrawRequestedEventMetric.eventReceived();
                    break;
                }
                case WITHDRAWN: {
                    this.intentWithdrawnEventMetric.eventReceived();
                    break;
                }
                case PURGED: {
                    this.intentPurgedEventMetric.eventReceived();
                    break;
                }
            }
            while (this.lastEvents.size() >= 100) {
                this.lastEvents.remove();
            }
            this.lastEvents.add(event);
        }
        log.debug("Intent Event: time = {} type = {} event = {}", new Object[]{event.time(), event.type(), event});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        LinkedList<IntentEvent> linkedList = this.lastEvents;
        synchronized (linkedList) {
            this.lastEvents.clear();
        }
    }

    private void registerMetrics() {
        this.intentSubmittedEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_SUBMITTED_NAME);
        this.intentInstalledEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_INSTALLED_NAME);
        this.intentFailedEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_FAILED_NAME);
        this.intentWithdrawRequestedEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_WITHDRAW_REQUESTED_NAME);
        this.intentWithdrawnEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_WITHDRAWN_NAME);
        this.intentPurgedEventMetric = new EventMetric(this.metricsService, COMPONENT_NAME, FEATURE_PURGED_NAME);
        this.intentSubmittedEventMetric.registerMetrics();
        this.intentInstalledEventMetric.registerMetrics();
        this.intentFailedEventMetric.registerMetrics();
        this.intentWithdrawRequestedEventMetric.registerMetrics();
        this.intentWithdrawnEventMetric.registerMetrics();
        this.intentPurgedEventMetric.registerMetrics();
    }

    private void removeMetrics() {
        this.intentSubmittedEventMetric.removeMetrics();
        this.intentInstalledEventMetric.removeMetrics();
        this.intentFailedEventMetric.removeMetrics();
        this.intentWithdrawRequestedEventMetric.removeMetrics();
        this.intentWithdrawnEventMetric.removeMetrics();
        this.intentPurgedEventMetric.removeMetrics();
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }
}

