/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.snmp.ctl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.onosproject.net.DeviceId;
import org.onosproject.snmp.SnmpDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSnmpDevice
implements SnmpDevice {
    private final Logger log = LoggerFactory.getLogger(DefaultSnmpDevice.class);
    private static final int DEFAULT_SNMP_PORT = 161;
    private static final String SCHEME = "snmp";
    private final String snmpHost;
    private final DeviceId deviceId;
    private int snmpPort = 161;
    private final String username;
    private final String community;
    private boolean reachable = false;

    public DefaultSnmpDevice(String snmpHost, int snmpPort, String username, String community) {
        this.snmpHost = (String)Preconditions.checkNotNull((Object)snmpHost, (Object)"SNMP Device IP cannot be null");
        this.snmpPort = (Integer)Preconditions.checkNotNull((Object)snmpPort, (Object)"SNMP Device port cannot be null");
        this.username = username;
        this.community = community;
        this.deviceId = this.createDeviceId();
        this.reachable = true;
    }

    public String deviceInfo() {
        return "host: " + this.snmpHost + ". port: " + this.snmpPort;
    }

    public void disconnect() {
        this.log.info("disconnect");
        this.reachable = false;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public String getSnmpHost() {
        return this.snmpHost;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public String getUsername() {
        return this.username;
    }

    public String getCommunity() {
        return this.community;
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    private DeviceId createDeviceId() {
        String additionalSsp = this.snmpHost + ":" + this.snmpPort;
        try {
            return DeviceId.deviceId((URI)new URI(SCHEME, additionalSsp, null));
        }
        catch (URISyntaxException e) {
            this.log.error("Syntax Error while creating URI for the device: " + additionalSsp + " couldn't persist the device onto the store", (Throwable)e);
            throw new IllegalArgumentException("Can't create device ID from " + additionalSsp, e);
        }
    }
}

