/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.snmp.ctl;

import com.btisystems.pronx.ems.core.snmp.DefaultSnmpConfigurationFactory;
import com.btisystems.pronx.ems.core.snmp.ISnmpConfiguration;
import com.btisystems.pronx.ems.core.snmp.ISnmpConfigurationFactory;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.ISnmpSessionFactory;
import com.btisystems.pronx.ems.core.snmp.SnmpSessionFactory;
import com.btisystems.pronx.ems.core.snmp.V2cSnmpConfiguration;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;
import org.onosproject.snmp.SnmpController;
import org.onosproject.snmp.SnmpDevice;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DefaultSnmpController
implements SnmpController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISnmpSessionFactory sessionFactory;
    protected final Map<DeviceId, ISnmpSession> sessionMap = new HashMap<DeviceId, ISnmpSession>();
    protected final Map<DeviceId, SnmpDevice> snmpDeviceMap = new ConcurrentHashMap<DeviceId, SnmpDevice>();

    @Activate
    public void activate(ComponentContext context) {
        this.sessionFactory = new SnmpSessionFactory((ISnmpConfigurationFactory)new DefaultSnmpConfigurationFactory((ISnmpConfiguration)new V2cSnmpConfiguration()));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.sessionMap.clear();
        this.snmpDeviceMap.clear();
        this.log.info("Stopped");
    }

    public ISnmpSession getSession(DeviceId deviceId) throws IOException {
        if (!this.sessionMap.containsKey(deviceId)) {
            SnmpDevice device = this.snmpDeviceMap.get(deviceId);
            String ipAddress = null;
            int port = -1;
            if (device != null) {
                ipAddress = device.getSnmpHost();
                port = device.getSnmpPort();
            } else {
                String[] deviceComponents = deviceId.toString().split(":");
                if (deviceComponents.length > 1) {
                    ipAddress = deviceComponents[1];
                    port = Integer.parseInt(deviceComponents[2]);
                } else {
                    this.log.error("Cannot obtain correct information from device id", (Object)deviceId);
                }
            }
            Preconditions.checkNotNull((Object)ipAddress, (Object)"ip address is empty, cannot start session");
            Preconditions.checkArgument((port != -1 ? 1 : 0) != 0, (Object)"port is incorrect, cannot start session");
            V2cSnmpConfiguration config = new V2cSnmpConfiguration();
            config.setPort(port);
            this.sessionMap.put(deviceId, this.sessionFactory.createSession((ISnmpConfiguration)config, ipAddress));
        }
        return this.sessionMap.get(deviceId);
    }

    public Collection<SnmpDevice> getDevices() {
        return this.snmpDeviceMap.values();
    }

    public SnmpDevice getDevice(DeviceId did) {
        return this.snmpDeviceMap.get(did);
    }

    public void removeDevice(DeviceId did) {
        this.snmpDeviceMap.remove(did);
    }

    public void addDevice(DeviceId did, SnmpDevice device) {
        this.snmpDeviceMap.put(did, device);
    }

    public DefaultAlarm buildWalkFailedAlarm(DeviceId deviceId) {
        return new DefaultAlarm.Builder(deviceId, "SNMP alarm retrieval failed", Alarm.SeverityLevel.CRITICAL, System.currentTimeMillis()).build();
    }
}

