/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.config;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.RouterConfig;
import org.onosproject.routing.config.RoutersConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RouterConfigHelper {
    private static final String WARNING = "Config apps/org.onosproject.routing/router is deprecated and will be removed in a future release.";
    private static final String WARNING2 = "Use apps/org.onosproject.routing/routers instead";
    private static final Logger log = LoggerFactory.getLogger(RouterConfigHelper.class);

    private RouterConfigHelper() {
    }

    public static Set<RoutersConfig.Router> getRouterConfigurations(NetworkConfigService configService, ApplicationId routingAppId) {
        RouterConfig config = (RouterConfig)configService.getConfig((Object)routingAppId, RoutingService.ROUTER_CONFIG_CLASS);
        RoutersConfig multiConfig = (RoutersConfig)configService.getConfig((Object)routingAppId, RoutersConfig.class);
        if (config != null) {
            log.warn(WARNING);
            log.warn(WARNING2);
            return Collections.singleton(new RoutersConfig.Router(config.getControlPlaneConnectPoint(), config.getOspfEnabled(), Sets.newHashSet(config.getInterfaces())));
        }
        if (multiConfig != null) {
            return multiConfig.getRouters();
        }
        return Collections.emptySet();
    }
}

