/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.routing.AsyncDeviceFetcher;
import org.onosproject.routing.InterfaceProvisionRequest;
import org.onosproject.routing.RouterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Consumer<InterfaceProvisionRequest> provisioner;
    private final Consumer<InterfaceProvisionRequest> unprovisioner;
    private RouterInfo info;
    private Set<Interface> provisioned = new HashSet<Interface>();
    private InterfaceService interfaceService;
    private InterfaceListener listener = new InternalInterfaceListener();
    private DeviceService deviceService;
    private AsyncDeviceFetcher asyncDeviceFetcher;

    public Router(RouterInfo info, InterfaceService interfaceService, DeviceService deviceService, Consumer<InterfaceProvisionRequest> provisioner, Consumer<InterfaceProvisionRequest> unprovisioner, boolean forceUnprovision) {
        this.info = (RouterInfo)Preconditions.checkNotNull((Object)info);
        this.provisioner = (Consumer)Preconditions.checkNotNull(provisioner);
        this.unprovisioner = (Consumer)Preconditions.checkNotNull(unprovisioner);
        this.interfaceService = (InterfaceService)Preconditions.checkNotNull((Object)interfaceService);
        this.deviceService = (DeviceService)Preconditions.checkNotNull((Object)deviceService);
        this.asyncDeviceFetcher = AsyncDeviceFetcher.create(deviceService);
        if (forceUnprovision) {
            this.asyncDeviceFetcher.registerCallback(info.deviceId(), this::provision, this::forceUnprovision);
        } else {
            this.asyncDeviceFetcher.registerCallback(info.deviceId(), this::provision, null);
        }
        interfaceService.addListener((EventListener)this.listener);
    }

    public void cleanup() {
        this.asyncDeviceFetcher.shutdown();
        this.interfaceService.removeListener((EventListener)this.listener);
        this.unprovision();
    }

    public RouterInfo info() {
        return this.info;
    }

    public void changeConfiguration(RouterInfo newConfig, boolean forceUnprovision) {
        if (forceUnprovision) {
            this.asyncDeviceFetcher.registerCallback(this.info.deviceId(), this::provision, this::forceUnprovision);
        } else {
            this.asyncDeviceFetcher.registerCallback(this.info.deviceId(), this::provision, null);
        }
        Set<String> oldConfiguredInterfaces = this.info.interfaces();
        this.info = newConfig;
        Set<String> newConfiguredInterfaces = this.info.interfaces();
        if (newConfiguredInterfaces.isEmpty() && !oldConfiguredInterfaces.isEmpty()) {
            this.getInterfacesForDevice(this.info.deviceId()).filter(intf -> !oldConfiguredInterfaces.contains(intf.name())).forEach(this::provision);
        } else if (!newConfiguredInterfaces.isEmpty() && oldConfiguredInterfaces.isEmpty()) {
            this.getInterfacesForDevice(this.info.deviceId()).filter(intf -> !newConfiguredInterfaces.contains(intf.name())).forEach(this::unprovision);
        } else {
            Sets.SetView toUnprovision = Sets.difference(oldConfiguredInterfaces, newConfiguredInterfaces);
            Sets.SetView toProvision = Sets.difference(newConfiguredInterfaces, oldConfiguredInterfaces);
            toUnprovision.forEach(name -> this.getInterfacesForDevice(this.info.deviceId()).filter(intf -> intf.name().equals(name)).findFirst().ifPresent(this::unprovision));
            toProvision.forEach(name -> this.getInterfacesForDevice(this.info.deviceId()).filter(intf -> intf.name().equals(name)).findFirst().ifPresent(this::provision));
        }
    }

    private void provision() {
        this.getInterfacesForDevice(this.info.deviceId()).forEach(this::provision);
    }

    private void unprovision() {
        this.getInterfacesForDevice(this.info.deviceId()).forEach(this::unprovision);
    }

    private void forceUnprovision() {
        this.getInterfacesForDevice(this.info.deviceId()).forEach(this::forceUnprovision);
    }

    private void provision(Interface intf) {
        if (!this.provisioned.contains(intf) && this.deviceAvailable(intf) && this.shouldProvision(intf)) {
            this.log.info("Provisioning interface {}", (Object)intf);
            this.provisioner.accept(InterfaceProvisionRequest.of(this.info, intf));
            this.provisioned.add(intf);
        }
    }

    private void unprovision(Interface intf) {
        if (this.provisioned.contains(intf) && this.deviceAvailable(intf) && this.shouldProvision(intf)) {
            this.log.info("Unprovisioning interface {}", (Object)intf);
            this.unprovisioner.accept(InterfaceProvisionRequest.of(this.info, intf));
            this.provisioned.remove(intf);
        }
    }

    private void forceUnprovision(Interface intf) {
        if (this.provisioned.contains(intf) && this.shouldProvision(intf)) {
            this.log.info("Unprovisioning interface {}", (Object)intf);
            this.unprovisioner.accept(InterfaceProvisionRequest.of(this.info, intf));
            this.provisioned.remove(intf);
        }
    }

    private boolean deviceAvailable(Interface intf) {
        return this.deviceService.isAvailable(intf.connectPoint().deviceId());
    }

    private boolean shouldProvision(Interface intf) {
        return this.info.interfaces().isEmpty() || this.info.interfaces().contains(intf.name());
    }

    private Stream<Interface> getInterfacesForDevice(DeviceId deviceId) {
        return this.interfaceService.getInterfaces().stream().filter(intf -> intf.connectPoint().deviceId().equals((Object)deviceId));
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            Interface intf = (Interface)event.subject();
            switch ((InterfaceEvent.Type)event.type()) {
                case INTERFACE_ADDED: {
                    Router.this.provision(intf);
                    break;
                }
                case INTERFACE_UPDATED: {
                    break;
                }
                case INTERFACE_REMOVED: {
                    Router.this.unprovision(intf);
                    break;
                }
            }
        }
    }
}

