/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;

public final class AsyncDeviceFetcher {
    private DeviceService deviceService;
    private DeviceListener listener = new InternalDeviceListener();
    private Map<DeviceId, Runnable> onConnect = new ConcurrentHashMap<DeviceId, Runnable>();
    private Map<DeviceId, Runnable> onDisconnect = new ConcurrentHashMap<DeviceId, Runnable>();

    private AsyncDeviceFetcher(DeviceService deviceService) {
        this.deviceService = (DeviceService)Preconditions.checkNotNull((Object)deviceService);
        deviceService.addListener((EventListener)this.listener);
    }

    public void shutdown() {
        this.deviceService.removeListener((EventListener)this.listener);
        this.onConnect.clear();
        this.onDisconnect.clear();
    }

    void registerCallback(DeviceId deviceId, Runnable onConnect, Runnable onDisconnect) {
        if (onConnect != null) {
            if (this.deviceService.isAvailable(deviceId)) {
                onConnect.run();
            }
            this.onConnect.put(deviceId, onConnect);
        }
        if (onDisconnect != null) {
            this.onDisconnect.put(deviceId, onDisconnect);
        }
    }

    public static AsyncDeviceFetcher create(DeviceService deviceService) {
        return new AsyncDeviceFetcher(deviceService);
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    DeviceId deviceId = ((Device)event.subject()).id();
                    if (AsyncDeviceFetcher.this.deviceService.isAvailable(deviceId)) {
                        Optional.ofNullable(AsyncDeviceFetcher.this.onConnect.get(deviceId)).ifPresent(Runnable::run);
                        break;
                    }
                    Optional.ofNullable(AsyncDeviceFetcher.this.onDisconnect.get(deviceId)).ifPresent(Runnable::run);
                    break;
                }
            }
        }
    }
}

