/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.tunnel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.onlab.util.Timer;
import org.onosproject.pcep.api.PcepController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelStatsCollector
implements TimerTask {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PcepController controller;
    private int refreshInterval;
    private final HashedWheelTimer timer = Timer.getTimer();
    private String pcepTunnelId;
    private Timeout timeout;
    private volatile boolean stopped;

    public TunnelStatsCollector(String id, int refreshInterval) {
        this.pcepTunnelId = id;
        this.refreshInterval = refreshInterval;
    }

    public void run(Timeout timeout) throws Exception {
        if (this.stopped || timeout.isCancelled()) {
            return;
        }
        this.log.trace("Collecting stats for {}", (Object)this.pcepTunnelId);
        this.sendTunnelStatistic();
        if (!this.stopped && !timeout.isCancelled()) {
            this.log.trace("Scheduling stats collection in {} seconds for {}", (Object)this.refreshInterval, (Object)this.pcepTunnelId);
            timeout.getTimer().newTimeout((TimerTask)this, (long)this.refreshInterval, TimeUnit.SECONDS);
        }
    }

    private void sendTunnelStatistic() {
        this.controller.getTunnelStatistics(this.pcepTunnelId);
    }

    synchronized void adjustPollInterval(int pollInterval) {
        this.refreshInterval = pollInterval;
    }

    public synchronized void start() {
        this.log.info("Starting Tunnel Stats collection thread for {}", (Object)this.pcepTunnelId);
        this.stopped = false;
        this.timeout = this.timer.newTimeout((TimerTask)this, 1L, TimeUnit.SECONDS);
    }

    public synchronized void stop() {
        this.log.info("Stopping Tunnel Stats collection thread for {}", (Object)this.pcepTunnelId);
        this.stopped = true;
        this.timeout.cancel();
    }
}

