/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.utils;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.onlab.metrics.MetricsComponent;
import org.onlab.metrics.MetricsFeature;
import org.onlab.metrics.MetricsService;
import org.onlab.osgi.DefaultServiceDirectory;

public class MeteringAgent {
    private Counter exceptionCounter;
    private Counter perObjExceptionCounter;
    private MetricsService metricsService;
    private MetricsComponent metricsComponent;
    private MetricsFeature metricsFeature;
    private final Map<String, Timer> perObjOpTimers = Maps.newConcurrentMap();
    private final Map<String, Timer> perOpTimers = Maps.newConcurrentMap();
    private Timer perPrimitiveTimer;
    private Timer perObjTimer;
    private MetricsFeature wildcard;
    private final boolean activated;
    private Context nullTimer;

    public MeteringAgent(String primitiveName, String objName, boolean activated) {
        Preconditions.checkNotNull((Object)objName, (Object)"Object name cannot be null");
        this.activated = activated;
        this.nullTimer = new Context(null, "");
        if (this.activated) {
            this.metricsService = (MetricsService)DefaultServiceDirectory.getService(MetricsService.class);
            this.metricsComponent = this.metricsService.registerComponent(primitiveName);
            this.metricsFeature = this.metricsComponent.registerFeature(objName);
            this.wildcard = this.metricsComponent.registerFeature("*");
            this.perObjTimer = this.metricsService.createTimer(this.metricsComponent, this.metricsFeature, "*");
            this.perPrimitiveTimer = this.metricsService.createTimer(this.metricsComponent, this.wildcard, "*");
            this.perObjExceptionCounter = this.metricsService.createCounter(this.metricsComponent, this.metricsFeature, "exceptions");
            this.exceptionCounter = this.metricsService.createCounter(this.metricsComponent, this.wildcard, "exceptions");
        }
    }

    public Context startTimer(String op) {
        if (!this.activated) {
            return this.nullTimer;
        }
        Timer currTimer = this.perObjOpTimers.computeIfAbsent(op, timer -> this.metricsService.createTimer(this.metricsComponent, this.metricsFeature, op));
        this.perOpTimers.computeIfAbsent(op, timer -> this.metricsService.createTimer(this.metricsComponent, this.wildcard, op));
        return new Context(currTimer.time(), op);
    }

    public class Context {
        private final Timer.Context context;
        private final String operation;

        public Context(Timer.Context context, String operation) {
            this.context = context;
            this.operation = operation;
        }

        public void stop(Throwable e) {
            if (!MeteringAgent.this.activated) {
                return;
            }
            if (e == null) {
                long time = this.context.stop();
                ((Timer)MeteringAgent.this.perOpTimers.get(this.operation)).update(time, TimeUnit.NANOSECONDS);
                MeteringAgent.this.perObjTimer.update(time, TimeUnit.NANOSECONDS);
                MeteringAgent.this.perPrimitiveTimer.update(time, TimeUnit.NANOSECONDS);
            } else {
                MeteringAgent.this.exceptionCounter.inc();
                MeteringAgent.this.perObjExceptionCounter.inc();
            }
        }
    }
}

