/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.common.net;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public abstract class AbstractDeviceProvider
extends AbstractProvider
implements DeviceProvider {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    protected DeviceProviderService providerService;

    protected AbstractDeviceProvider(ProviderId id) {
        super(id);
    }

    @Activate
    protected void activate() {
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.log.info("Stopped");
    }

    protected void discoverDevice(DriverHandler handler) {
        DeviceId deviceId = handler.data().deviceId();
        DeviceDescriptionDiscovery discovery = (DeviceDescriptionDiscovery)handler.behaviour(DeviceDescriptionDiscovery.class);
        DeviceDescription description = discovery.discoverDeviceDetails();
        if (description != null) {
            this.providerService.deviceConnected(deviceId, description);
        } else {
            this.log.info("No other description given for device {}", (Object)deviceId);
        }
        this.providerService.updatePorts(deviceId, discovery.discoverPortDetails());
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }
}

