/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.common;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onlab.graph.DefaultEdgeWeigher;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.DisjointPathPair;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.KShortestPathsSearch;
import org.onlab.graph.LazyKShortestPathsSearch;
import org.onlab.graph.Path;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.SrlgGraphSearch;
import org.onlab.graph.SuurballeGraphSearch;
import org.onlab.graph.TarjanGraphSearch;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;
import org.onlab.util.GuavaCollectors;
import org.onlab.util.Tools;
import org.onosproject.common.DefaultTopologyGraph;
import org.onosproject.core.CoreService;
import org.onosproject.net.AbstractModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDisjointPath;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.Link;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.AdapterLinkWeigher;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.DefaultTopologyCluster;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.GraphDescription;
import org.onosproject.net.topology.HopCountLinkWeight;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTopology
extends AbstractModel
implements Topology {
    private static final Logger log = LoggerFactory.getLogger(DefaultTopology.class);
    private static final DijkstraGraphSearch<TopologyVertex, TopologyEdge> DIJKSTRA = new DijkstraGraphSearch();
    private static final TarjanGraphSearch<TopologyVertex, TopologyEdge> TARJAN = new TarjanGraphSearch();
    private static final SuurballeGraphSearch<TopologyVertex, TopologyEdge> SUURBALLE = new SuurballeGraphSearch();
    private static final KShortestPathsSearch<TopologyVertex, TopologyEdge> KSHORTEST = new KShortestPathsSearch();
    private static final LazyKShortestPathsSearch<TopologyVertex, TopologyEdge> LAZY_KSHORTEST = new LazyKShortestPathsSearch();
    private static LinkWeigher defaultLinkWeigher = null;
    private static GraphPathSearch<TopologyVertex, TopologyEdge> defaultGraphPathSearch = null;
    private final long time;
    private final long creationTime;
    private final long computeCost;
    private final TopologyGraph graph;
    private final LinkWeigher hopCountWeigher;
    private final Supplier<TarjanGraphSearch.SccResult<TopologyVertex, TopologyEdge>> clusterResults;
    private final Supplier<ImmutableMap<ClusterId, TopologyCluster>> clusters;
    private final Supplier<ImmutableSet<ConnectPoint>> infrastructurePoints;
    private final Supplier<ImmutableSetMultimap<ClusterId, ConnectPoint>> broadcastSets;
    private final Function<ConnectPoint, Boolean> broadcastFunction;
    private final Supplier<ClusterIndexes> clusterIndexes;

    public static void setDefaultLinkWeigher(LinkWeigher linkWeigher) {
        log.info("Setting new default link-weight function to {}", (Object)linkWeigher);
        defaultLinkWeigher = linkWeigher;
    }

    public static void setDefaultGraphPathSearch(GraphPathSearch<TopologyVertex, TopologyEdge> graphPathSearch) {
        log.info("Setting new default graph path algorithm to {}", graphPathSearch);
        defaultGraphPathSearch = graphPathSearch;
    }

    public DefaultTopology(ProviderId providerId, GraphDescription description, Function<ConnectPoint, Boolean> broadcastFunction) {
        super(providerId, new Annotations[0]);
        this.broadcastFunction = broadcastFunction;
        this.time = description.timestamp();
        this.creationTime = description.creationTime();
        this.graph = new DefaultTopologyGraph((Set<TopologyVertex>)description.vertexes(), (Set<TopologyEdge>)description.edges());
        this.clusterResults = Suppliers.memoize(this::searchForClusters);
        this.clusters = Suppliers.memoize(this::buildTopologyClusters);
        this.clusterIndexes = Suppliers.memoize(this::buildIndexes);
        this.hopCountWeigher = AdapterLinkWeigher.adapt((LinkWeight)new HopCountLinkWeight(this.graph.getVertexes().size()));
        this.broadcastSets = Suppliers.memoize(this::buildBroadcastSets);
        this.infrastructurePoints = Suppliers.memoize(this::findInfrastructurePoints);
        this.computeCost = Math.max(0L, System.nanoTime() - this.time);
    }

    public DefaultTopology(ProviderId providerId, GraphDescription description) {
        this(providerId, description, null);
    }

    public long time() {
        return this.time;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long computeCost() {
        return this.computeCost;
    }

    public int clusterCount() {
        return ((ImmutableMap)this.clusters.get()).size();
    }

    public int deviceCount() {
        return this.graph.getVertexes().size();
    }

    public int linkCount() {
        return this.graph.getEdges().size();
    }

    private ImmutableMap<DeviceId, TopologyCluster> clustersByDevice() {
        return ((ClusterIndexes)this.clusterIndexes.get()).clustersByDevice;
    }

    private ImmutableSetMultimap<TopologyCluster, DeviceId> devicesByCluster() {
        return ((ClusterIndexes)this.clusterIndexes.get()).devicesByCluster;
    }

    private ImmutableSetMultimap<TopologyCluster, Link> linksByCluster() {
        return ((ClusterIndexes)this.clusterIndexes.get()).linksByCluster;
    }

    public TopologyGraph getGraph() {
        return this.graph;
    }

    public Set<TopologyCluster> getClusters() {
        return ImmutableSet.copyOf((Collection)((ImmutableMap)this.clusters.get()).values());
    }

    public TopologyCluster getCluster(ClusterId clusterId) {
        return (TopologyCluster)((ImmutableMap)this.clusters.get()).get((Object)clusterId);
    }

    public TopologyCluster getCluster(DeviceId deviceId) {
        return (TopologyCluster)this.clustersByDevice().get((Object)deviceId);
    }

    public Set<DeviceId> getClusterDevices(TopologyCluster cluster) {
        return this.devicesByCluster().get((Object)cluster);
    }

    public Set<Link> getClusterLinks(TopologyCluster cluster) {
        return this.linksByCluster().get((Object)cluster);
    }

    public boolean isInfrastructure(ConnectPoint connectPoint) {
        return ((ImmutableSet)this.infrastructurePoints.get()).contains((Object)connectPoint);
    }

    public boolean isBroadcastPoint(ConnectPoint connectPoint) {
        if (this.broadcastFunction != null) {
            return (Boolean)this.broadcastFunction.apply((Object)connectPoint);
        }
        if (!this.isInfrastructure(connectPoint)) {
            return true;
        }
        TopologyCluster cluster = (TopologyCluster)this.clustersByDevice().get((Object)connectPoint.deviceId());
        Preconditions.checkArgument((cluster != null ? 1 : 0) != 0, (String)"No cluster found for device %s", (Object)connectPoint.deviceId());
        ImmutableSet points = ((ImmutableSetMultimap)this.broadcastSets.get()).get((Object)cluster.id());
        return Tools.isNullOrEmpty((Collection)points) || points.contains(connectPoint);
    }

    public int broadcastSetSize(ClusterId clusterId) {
        return ((ImmutableSetMultimap)this.broadcastSets.get()).get((Object)clusterId).size();
    }

    public Set<ConnectPoint> broadcastPoints(ClusterId clusterId) {
        return ((ImmutableSetMultimap)this.broadcastSets.get()).get((Object)clusterId);
    }

    public Set<org.onosproject.net.Path> getPaths(DeviceId src, DeviceId dst) {
        return this.getPaths(src, dst, this.linkWeight(), -1);
    }

    public Set<org.onosproject.net.Path> getPaths(DeviceId src, DeviceId dst, LinkWeigher weigher) {
        return this.getPaths(src, dst, weigher, -1);
    }

    public Set<org.onosproject.net.Path> getPaths(DeviceId src, DeviceId dst, LinkWeigher weigher, int maxPaths) {
        DefaultTopologyVertex srcV = new DefaultTopologyVertex(src);
        DefaultTopologyVertex dstV = new DefaultTopologyVertex(dst);
        Set vertices = this.graph.getVertexes();
        if (!vertices.contains(srcV) || !vertices.contains(dstV)) {
            return ImmutableSet.of();
        }
        GraphPathSearch.Result result = this.graphPathSearch().search((Graph)this.graph, (Vertex)srcV, (Vertex)dstV, (EdgeWeigher)weigher, maxPaths);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Path path : result.paths()) {
            builder.add((Object)this.networkPath((Path<TopologyVertex, TopologyEdge>)path));
        }
        return builder.build();
    }

    public Set<org.onosproject.net.Path> getKShortestPaths(DeviceId src, DeviceId dst, int maxPaths) {
        return this.getKShortestPaths(src, dst, this.linkWeight(), maxPaths);
    }

    public Set<org.onosproject.net.Path> getKShortestPaths(DeviceId src, DeviceId dst, LinkWeigher weigher, int maxPaths) {
        DefaultTopologyVertex srcV = new DefaultTopologyVertex(src);
        DefaultTopologyVertex dstV = new DefaultTopologyVertex(dst);
        Set vertices = this.graph.getVertexes();
        if (!vertices.contains(srcV) || !vertices.contains(dstV)) {
            return ImmutableSet.of();
        }
        return (Set)KSHORTEST.search((Graph)this.graph, (Vertex)srcV, (Vertex)dstV, (EdgeWeigher)weigher, maxPaths).paths().stream().map(this::networkPath).collect(GuavaCollectors.toImmutableSet());
    }

    public Stream<org.onosproject.net.Path> getKShortestPaths(DeviceId src, DeviceId dst) {
        return this.getKShortestPaths(src, dst, this.linkWeight());
    }

    public Stream<org.onosproject.net.Path> getKShortestPaths(DeviceId src, DeviceId dst, LinkWeigher weigher) {
        DefaultTopologyVertex srcV = new DefaultTopologyVertex(src);
        DefaultTopologyVertex dstV = new DefaultTopologyVertex(dst);
        Set vertices = this.graph.getVertexes();
        if (!vertices.contains(srcV) || !vertices.contains(dstV)) {
            return Stream.empty();
        }
        return LAZY_KSHORTEST.lazyPathSearch((Graph)this.graph, (Vertex)srcV, (Vertex)dstV, (EdgeWeigher)weigher).map(this::networkPath);
    }

    public Set<DisjointPath> getDisjointPaths(DeviceId src, DeviceId dst) {
        return this.getDisjointPaths(src, dst, this.linkWeight());
    }

    public Set<DisjointPath> getDisjointPaths(DeviceId src, DeviceId dst, LinkWeigher weigher) {
        DefaultTopologyVertex srcV = new DefaultTopologyVertex(src);
        DefaultTopologyVertex dstV = new DefaultTopologyVertex(dst);
        Set vertices = this.graph.getVertexes();
        if (!vertices.contains(srcV) || !vertices.contains(dstV)) {
            return ImmutableSet.of();
        }
        GraphPathSearch.Result result = SUURBALLE.search((Graph)this.graph, (Vertex)srcV, (Vertex)dstV, (EdgeWeigher)weigher, -1);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Path path : result.paths()) {
            DisjointPath disjointPath = this.networkDisjointPath((DisjointPathPair<TopologyVertex, TopologyEdge>)((DisjointPathPair)path));
            if (disjointPath.backup() == null) continue;
            builder.add((Object)disjointPath);
        }
        return builder.build();
    }

    private Set<DisjointPath> disjointPaths(DeviceId src, DeviceId dst, LinkWeigher weigher, Map<TopologyEdge, Object> riskProfile) {
        DefaultTopologyVertex srcV = new DefaultTopologyVertex(src);
        DefaultTopologyVertex dstV = new DefaultTopologyVertex(dst);
        Set vertices = this.graph.getVertexes();
        if (!vertices.contains(srcV) || !vertices.contains(dstV)) {
            return ImmutableSet.of();
        }
        SrlgGraphSearch srlg = new SrlgGraphSearch(riskProfile);
        GraphPathSearch.Result result = srlg.search((Graph)this.graph, (Vertex)srcV, (Vertex)dstV, (EdgeWeigher)weigher, -1);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Path path : result.paths()) {
            DisjointPath disjointPath = this.networkDisjointPath((DisjointPathPair<TopologyVertex, TopologyEdge>)((DisjointPathPair)path));
            if (disjointPath.backup() == null) continue;
            builder.add((Object)disjointPath);
        }
        return builder.build();
    }

    public Set<DisjointPath> getDisjointPaths(final DeviceId src, final DeviceId dst, LinkWeigher weigher, Map<Link, Object> riskProfile) {
        HashMap<TopologyEdge, Object> riskProfile2 = new HashMap<TopologyEdge, Object>();
        for (final Link l : riskProfile.keySet()) {
            riskProfile2.put(new TopologyEdge(){
                Link cur;
                {
                    this.cur = l;
                }

                public Link link() {
                    return this.cur;
                }

                public TopologyVertex src() {
                    return () -> src;
                }

                public TopologyVertex dst() {
                    return () -> dst;
                }
            }, riskProfile.get(l));
        }
        return this.disjointPaths(src, dst, weigher, riskProfile2);
    }

    public Set<DisjointPath> getDisjointPaths(DeviceId src, DeviceId dst, Map<Link, Object> riskProfile) {
        return this.getDisjointPaths(src, dst, this.linkWeight(), riskProfile);
    }

    private org.onosproject.net.Path networkPath(Path<TopologyVertex, TopologyEdge> path) {
        List links = path.edges().stream().map(TopologyEdge::link).collect(Collectors.toList());
        return new DefaultPath(CoreService.CORE_PROVIDER_ID, links, path.cost(), new Annotations[0]);
    }

    private DisjointPath networkDisjointPath(DisjointPathPair<TopologyVertex, TopologyEdge> path) {
        if (!path.hasBackup()) {
            return new DefaultDisjointPath(CoreService.CORE_PROVIDER_ID, (DefaultPath)this.networkPath((Path<TopologyVertex, TopologyEdge>)path.primary()), null);
        }
        return new DefaultDisjointPath(CoreService.CORE_PROVIDER_ID, (DefaultPath)this.networkPath((Path<TopologyVertex, TopologyEdge>)path.primary()), (DefaultPath)this.networkPath((Path<TopologyVertex, TopologyEdge>)path.secondary()));
    }

    private TarjanGraphSearch.SccResult<TopologyVertex, TopologyEdge> searchForClusters() {
        return TARJAN.search((Graph)this.graph, (EdgeWeigher)new NoIndirectLinksWeigher());
    }

    private ImmutableMap<ClusterId, TopologyCluster> buildTopologyClusters() {
        ImmutableMap.Builder clusterBuilder = ImmutableMap.builder();
        TarjanGraphSearch.SccResult results = (TarjanGraphSearch.SccResult)this.clusterResults.get();
        List clusterVertexes = results.clusterVertexes();
        List clusterEdges = results.clusterEdges();
        int n = results.clusterCount();
        for (int i = 0; i < n; ++i) {
            Set vertexSet = (Set)clusterVertexes.get(i);
            Set edgeSet = (Set)clusterEdges.get(i);
            ClusterId cid = ClusterId.clusterId((int)i);
            DefaultTopologyCluster cluster = new DefaultTopologyCluster(cid, vertexSet.size(), edgeSet.size(), this.findRoot(vertexSet));
            clusterBuilder.put((Object)cid, (Object)cluster);
        }
        return clusterBuilder.build();
    }

    private TopologyVertex findRoot(Set<TopologyVertex> vertexSet) {
        TopologyVertex minVertex = null;
        for (TopologyVertex vertex : vertexSet) {
            if (minVertex != null && vertex.deviceId().toString().compareTo(minVertex.deviceId().toString()) >= 0) continue;
            minVertex = vertex;
        }
        return minVertex;
    }

    private ImmutableSetMultimap<ClusterId, ConnectPoint> buildBroadcastSets() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (TopologyCluster cluster : ((ImmutableMap)this.clusters.get()).values()) {
            this.addClusterBroadcastSet(cluster, (ImmutableSetMultimap.Builder<ClusterId, ConnectPoint>)builder);
        }
        return builder.build();
    }

    private void addClusterBroadcastSet(TopologyCluster cluster, ImmutableSetMultimap.Builder<ClusterId, ConnectPoint> builder) {
        GraphPathSearch.Result result = DIJKSTRA.search((Graph)this.graph, (Vertex)cluster.root(), null, (EdgeWeigher)this.hopCountWeigher, 1);
        for (Map.Entry entry : result.parents().entrySet()) {
            Set parents;
            TopologyVertex vertex = (TopologyVertex)entry.getKey();
            if (this.clustersByDevice().get((Object)vertex.deviceId()) != cluster || (parents = (Set)entry.getValue()).isEmpty()) continue;
            Link link = ((TopologyEdge)parents.iterator().next()).link();
            builder.put((Object)cluster.id(), (Object)link.src());
            builder.put((Object)cluster.id(), (Object)link.dst());
        }
    }

    private ImmutableSet<ConnectPoint> findInfrastructurePoints() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (TopologyEdge edge : this.graph.getEdges()) {
            if (edge.link().type() == Link.Type.EDGE) continue;
            builder.add((Object)edge.link().src());
            builder.add((Object)edge.link().dst());
        }
        return builder.build();
    }

    private ClusterIndexes buildIndexes() {
        ImmutableMap.Builder clusterBuilder = ImmutableMap.builder();
        ImmutableSetMultimap.Builder devicesBuilder = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder linksBuilder = ImmutableSetMultimap.builder();
        for (TopologyCluster cluster : ((ImmutableMap)this.clusters.get()).values()) {
            int i = cluster.id().index();
            for (TopologyVertex vertex : (Set)((TarjanGraphSearch.SccResult)this.clusterResults.get()).clusterVertexes().get(i)) {
                devicesBuilder.put((Object)cluster, (Object)vertex.deviceId());
                clusterBuilder.put((Object)vertex.deviceId(), (Object)cluster);
            }
            for (TopologyEdge edge : (Set)((TarjanGraphSearch.SccResult)this.clusterResults.get()).clusterEdges().get(i)) {
                linksBuilder.put((Object)cluster, (Object)edge.link());
            }
        }
        return new ClusterIndexes((ImmutableMap<DeviceId, TopologyCluster>)clusterBuilder.build(), (ImmutableSetMultimap<TopologyCluster, DeviceId>)devicesBuilder.build(), (ImmutableSetMultimap<TopologyCluster, Link>)linksBuilder.build());
    }

    private GraphPathSearch<TopologyVertex, TopologyEdge> graphPathSearch() {
        return defaultGraphPathSearch != null ? defaultGraphPathSearch : DIJKSTRA;
    }

    private LinkWeigher linkWeight() {
        return defaultLinkWeigher != null ? defaultLinkWeigher : this.hopCountWeigher;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("time", this.time).add("creationTime", this.creationTime).add("computeCost", this.computeCost).add("clusters", this.clusterCount()).add("devices", this.deviceCount()).add("links", this.linkCount()).toString();
    }

    static final class ClusterIndexes {
        final ImmutableMap<DeviceId, TopologyCluster> clustersByDevice;
        final ImmutableSetMultimap<TopologyCluster, DeviceId> devicesByCluster;
        final ImmutableSetMultimap<TopologyCluster, Link> linksByCluster;

        public ClusterIndexes(ImmutableMap<DeviceId, TopologyCluster> clustersByDevice, ImmutableSetMultimap<TopologyCluster, DeviceId> devicesByCluster, ImmutableSetMultimap<TopologyCluster, Link> linksByCluster) {
            this.clustersByDevice = clustersByDevice;
            this.devicesByCluster = devicesByCluster;
            this.linksByCluster = linksByCluster;
        }
    }

    private static class NoIndirectLinksWeigher
    extends DefaultEdgeWeigher<TopologyVertex, TopologyEdge>
    implements LinkWeigher {
        private NoIndirectLinksWeigher() {
        }

        public Weight weight(TopologyEdge edge) {
            return edge.link().state() == Link.State.INACTIVE || edge.link().type() == Link.Type.INDIRECT ? this.getNonViableWeight() : new ScalarWeight(1.0);
        }
    }
}

