/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.virtual.DefaultVirtualPort;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;

public class VirtualPortCodec
extends JsonCodec<VirtualPort> {
    private static final String NETWORK_ID = "networkId";
    private static final String DEVICE_ID = "deviceId";
    private static final String PORT_NUM = "portNum";
    private static final String PHYS_DEVICE_ID = "physDeviceId";
    private static final String PHYS_PORT_NUM = "physPortNum";
    private static final String NULL_OBJECT_MSG = "VirtualPort cannot be null";
    private static final String MISSING_MEMBER_MSG = " member is required in VirtualPort";
    private static final String INVALID_VIRTUAL_DEVICE = " is not a valid VirtualDevice";

    public ObjectNode encode(VirtualPort vPort, CodecContext context) {
        Preconditions.checkNotNull((Object)vPort, (Object)NULL_OBJECT_MSG);
        ObjectNode result = context.mapper().createObjectNode().put(NETWORK_ID, vPort.networkId().toString()).put(DEVICE_ID, vPort.element().id().toString()).put(PORT_NUM, vPort.number().toString()).put(PHYS_DEVICE_ID, vPort.realizedBy().deviceId().toString()).put(PHYS_PORT_NUM, vPort.realizedBy().port().toString());
        return result;
    }

    public VirtualPort decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        NetworkId nId = NetworkId.networkId((long)Long.parseLong(this.extractMember(NETWORK_ID, json)));
        DeviceId dId = DeviceId.deviceId((String)this.extractMember(DEVICE_ID, json));
        VirtualNetworkService vnetService = (VirtualNetworkService)context.getService(VirtualNetworkService.class);
        Set vDevs = vnetService.getVirtualDevices(nId);
        VirtualDevice vDev = vDevs.stream().filter(virtualDevice -> virtualDevice.id().equals((Object)dId)).findFirst().orElse(null);
        Tools.nullIsIllegal((Object)vDev, (String)(dId.toString() + INVALID_VIRTUAL_DEVICE));
        PortNumber portNum = PortNumber.portNumber((String)this.extractMember(PORT_NUM, json));
        DeviceId physDId = DeviceId.deviceId((String)this.extractMember(PHYS_DEVICE_ID, json));
        PortNumber physPortNum = PortNumber.portNumber((String)this.extractMember(PHYS_PORT_NUM, json));
        ConnectPoint realizedBy = new ConnectPoint((ElementId)physDId, physPortNum);
        return new DefaultVirtualPort(nId, (Device)vDev, portNum, realizedBy);
    }

    private String extractMember(String key, ObjectNode json) {
        return ((JsonNode)Tools.nullIsIllegal((Object)json.get(key), (String)(key + MISSING_MEMBER_MSG))).asText();
    }
}

