/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.virtual.DefaultVirtualNetwork;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualNetwork;

public class VirtualNetworkCodec
extends JsonCodec<VirtualNetwork> {
    private static final String NETWORK_ID = "networkId";
    private static final String TENANT_ID = "tenantId";
    private static final String NULL_OBJECT_MSG = "VirtualNetwork cannot be null";
    private static final String MISSING_MEMBER_MSG = " member is required in VirtualNetwork";

    public ObjectNode encode(VirtualNetwork vnet, CodecContext context) {
        Preconditions.checkNotNull((Object)vnet, (Object)NULL_OBJECT_MSG);
        ObjectNode result = context.mapper().createObjectNode().put(NETWORK_ID, vnet.id().toString()).put(TENANT_ID, vnet.tenantId().toString());
        return result;
    }

    public VirtualNetwork decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        NetworkId nId = NetworkId.networkId((long)Long.parseLong(this.extractMember(NETWORK_ID, json)));
        TenantId tId = TenantId.tenantId((String)this.extractMember(TENANT_ID, json));
        return new DefaultVirtualNetwork(nId, tId);
    }

    private String extractMember(String key, ObjectNode json) {
        return ((JsonNode)Tools.nullIsIllegal((Object)json.get(key), (String)(key + MISSING_MEMBER_MSG))).asText();
    }
}

