/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.virtual.DefaultVirtualLink;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.net.Link;

public class VirtualLinkCodec
extends JsonCodec<VirtualLink> {
    private static final String NETWORK_ID = "networkId";
    private static final String NULL_OBJECT_MSG = "VirtualLink cannot be null";
    private static final String MISSING_MEMBER_MSG = " member is required in VirtualLink";

    public ObjectNode encode(VirtualLink vLink, CodecContext context) {
        Preconditions.checkNotNull((Object)vLink, (Object)NULL_OBJECT_MSG);
        ObjectNode result = context.mapper().createObjectNode().put(NETWORK_ID, vLink.networkId().toString());
        JsonCodec codec = context.codec(Link.class);
        ObjectNode linkResult = codec.encode((Object)vLink, context);
        result.setAll(linkResult);
        return result;
    }

    public VirtualLink decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonCodec codec = context.codec(Link.class);
        Link link = (Link)codec.decode(json, context);
        NetworkId nId = NetworkId.networkId((long)Long.parseLong(this.extractMember(NETWORK_ID, json)));
        return DefaultVirtualLink.builder().networkId(nId).src(link.src()).dst(link.dst()).build();
    }

    private String extractMember(String key, ObjectNode json) {
        return ((JsonNode)Tools.nullIsIllegal((Object)json.get(key), (String)(key + MISSING_MEMBER_MSG))).asText();
    }
}

