/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Iterator;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.virtual.DefaultVirtualHost;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;

public class VirtualHostCodec
extends JsonCodec<VirtualHost> {
    static final String NETWORK_ID = "networkId";
    static final String HOST_ID = "id";
    static final String MAC_ADDRESS = "mac";
    static final String VLAN = "vlan";
    static final String IP_ADDRESSES = "ipAddresses";
    static final String HOST_LOCATION = "location";
    private static final String NULL_OBJECT_MSG = "VirtualHost cannot be null";
    private static final String MISSING_MEMBER_MSG = " member is required in VirtualHost";

    public ObjectNode encode(VirtualHost vHost, CodecContext context) {
        Preconditions.checkNotNull((Object)vHost, (Object)NULL_OBJECT_MSG);
        JsonCodec locationCodec = context.codec(HostLocation.class);
        ObjectNode result = context.mapper().createObjectNode().put(NETWORK_ID, vHost.networkId().toString()).put(HOST_ID, vHost.id().toString()).put(MAC_ADDRESS, vHost.mac().toString()).put(VLAN, vHost.vlan().toString());
        ArrayNode jsonIpAddresses = result.putArray(IP_ADDRESSES);
        for (IpAddress ipAddress : vHost.ipAddresses()) {
            jsonIpAddresses.add(ipAddress.toString());
        }
        result.set(IP_ADDRESSES, (JsonNode)jsonIpAddresses);
        result.set(HOST_LOCATION, (JsonNode)locationCodec.encode((Object)vHost.location(), context));
        return result;
    }

    public VirtualHost decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        NetworkId nId = NetworkId.networkId((long)Long.parseLong(this.extractMember(NETWORK_ID, json)));
        MacAddress mac = MacAddress.valueOf((String)json.get(MAC_ADDRESS).asText());
        VlanId vlanId = VlanId.vlanId((short)((short)json.get(VLAN).asInt(-1)));
        JsonNode locationNode = json.get(HOST_LOCATION);
        PortNumber portNumber = PortNumber.portNumber((String)locationNode.get("port").asText());
        DeviceId deviceId = DeviceId.deviceId((String)locationNode.get("elementId").asText());
        HostLocation hostLocation = new HostLocation(deviceId, portNumber, 0L);
        HostId id = HostId.hostId((MacAddress)mac, (VlanId)vlanId);
        Iterator ipStrings = json.get(IP_ADDRESSES).elements();
        HashSet<IpAddress> ips = new HashSet<IpAddress>();
        while (ipStrings.hasNext()) {
            ips.add(IpAddress.valueOf((String)((JsonNode)ipStrings.next()).asText()));
        }
        return new DefaultVirtualHost(nId, id, mac, vlanId, hostLocation, ips);
    }

    private String extractMember(String key, ObjectNode json) {
        return ((JsonNode)Tools.nullIsIllegal((Object)json.get(key), (String)(key + MISSING_MEMBER_MSG))).asText();
    }
}

