/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.virtual.DefaultVirtualDevice;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.net.DeviceId;

public class VirtualDeviceCodec
extends JsonCodec<VirtualDevice> {
    private static final String ID = "deviceId";
    private static final String NETWORK_ID = "networkId";
    private static final String NULL_OBJECT_MSG = "VirtualDevice cannot be null";
    private static final String MISSING_MEMBER_MSG = " member is required in VirtualDevice";

    public ObjectNode encode(VirtualDevice vDev, CodecContext context) {
        Preconditions.checkNotNull((Object)vDev, (Object)NULL_OBJECT_MSG);
        ObjectNode result = context.mapper().createObjectNode().put(NETWORK_ID, vDev.networkId().toString()).put(ID, vDev.id().toString());
        return result;
    }

    public VirtualDevice decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        DeviceId dId = DeviceId.deviceId((String)this.extractMember(ID, json));
        NetworkId nId = NetworkId.networkId((long)Long.parseLong(this.extractMember(NETWORK_ID, json)));
        return new DefaultVirtualDevice(nId, dId);
    }

    private String extractMember(String key, ObjectNode json) {
        return ((JsonNode)Tools.nullIsIllegal((Object)json.get(key), (String)(key + MISSING_MEMBER_MSG))).asText();
    }
}

