/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.stream.IntStream;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;

public final class TrafficTreatmentCodec
extends JsonCodec<TrafficTreatment> {
    private static final String INSTRUCTIONS = "instructions";
    private static final String DEFERRED = "deferred";
    private static final String CLEAR_DEFERRED = "clearDeferred";

    public ObjectNode encode(TrafficTreatment treatment, CodecContext context) {
        Preconditions.checkNotNull((Object)treatment, (Object)"Traffic treatment cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        ArrayNode jsonInstructions = result.putArray(INSTRUCTIONS);
        JsonCodec instructionCodec = context.codec(Instruction.class);
        for (Instruction instruction : treatment.immediate()) {
            jsonInstructions.add((JsonNode)instructionCodec.encode((Object)instruction, context));
        }
        if (treatment.metered() != null) {
            jsonInstructions.add((JsonNode)instructionCodec.encode((Object)treatment.metered(), context));
        }
        if (treatment.tableTransition() != null) {
            jsonInstructions.add((JsonNode)instructionCodec.encode((Object)treatment.tableTransition(), context));
        }
        if (treatment.clearedDeferred()) {
            result.put(CLEAR_DEFERRED, true);
        }
        ArrayNode jsonDeferred = result.putArray(DEFERRED);
        for (Instruction instruction : treatment.deferred()) {
            jsonDeferred.add((JsonNode)instructionCodec.encode((Object)instruction, context));
        }
        return result;
    }

    public TrafficTreatment decode(ObjectNode json, CodecContext context) {
        JsonNode deferredJson;
        JsonNode clearDeferred;
        JsonCodec instructionsCodec = context.codec(Instruction.class);
        JsonNode instructionsJson = json.get(INSTRUCTIONS);
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        if (instructionsJson != null) {
            IntStream.range(0, instructionsJson.size()).forEach(i -> builder.add((Instruction)instructionsCodec.decode(TrafficTreatmentCodec.get((JsonNode)instructionsJson, (int)i), context)));
        }
        if ((clearDeferred = json.get(CLEAR_DEFERRED)) != null && clearDeferred.asBoolean(false)) {
            builder.wipeDeferred();
        }
        if ((deferredJson = json.get(DEFERRED)) != null) {
            IntStream.range(0, deferredJson.size()).forEach(i -> builder.deferred().add((Instruction)instructionsCodec.decode(TrafficTreatmentCodec.get((JsonNode)deferredJson, (int)i), context)));
        }
        return builder.build();
    }
}

