/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.stream.IntStream;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.Criterion;

public final class TrafficSelectorCodec
extends JsonCodec<TrafficSelector> {
    private static final String CRITERIA = "criteria";

    public ObjectNode encode(TrafficSelector selector, CodecContext context) {
        Preconditions.checkNotNull((Object)selector, (Object)"Traffic selector cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        ArrayNode jsonCriteria = result.putArray(CRITERIA);
        if (selector.criteria() != null) {
            JsonCodec criterionCodec = context.codec(Criterion.class);
            for (Criterion criterion : selector.criteria()) {
                jsonCriteria.add((JsonNode)criterionCodec.encode((Object)criterion, context));
            }
        }
        return result;
    }

    public TrafficSelector decode(ObjectNode json, CodecContext context) {
        JsonCodec criterionCodec = context.codec(Criterion.class);
        JsonNode criteriaJson = json.get(CRITERIA);
        TrafficSelector.Builder builder = DefaultTrafficSelector.builder();
        if (criteriaJson != null) {
            IntStream.range(0, criteriaJson.size()).forEach(i -> builder.add((Criterion)criterionCodec.decode(TrafficSelectorCodec.get((JsonNode)criteriaJson, (int)i), context)));
        }
        return builder.build();
    }
}

