/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.virtual.TenantId;

public class TenantIdCodec
extends JsonCodec<TenantId> {
    private static final String TENANT_ID = "id";
    private static final String NULL_TENANT_MSG = "TenantId cannot be null";
    private static final String MISSING_MEMBER_MSG = " member is required in TenantId";

    public ObjectNode encode(TenantId tenantId, CodecContext context) {
        Preconditions.checkNotNull((Object)tenantId, (Object)NULL_TENANT_MSG);
        ObjectNode result = context.mapper().createObjectNode().put(TENANT_ID, (String)tenantId.id());
        return result;
    }

    public TenantId decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        TenantId tenantId = TenantId.tenantId((String)this.extractMember(TENANT_ID, json));
        return tenantId;
    }

    private String extractMember(String key, ObjectNode json) {
        return ((JsonNode)Tools.nullIsIllegal((Object)json.get(key), (String)(key + MISSING_MEMBER_MSG))).asText();
    }
}

