/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.ConnectivityIntentCodec;
import org.onosproject.codec.impl.IntentCodec;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

public class SinglePointToMultiPointIntentCodec
extends JsonCodec<SinglePointToMultiPointIntent> {
    private static final String INGRESS_POINT = "ingressPoint";
    private static final String EGRESS_POINT = "egressPoint";
    private static final String CP_POINTS = "connectPoints";

    public ObjectNode encode(SinglePointToMultiPointIntent intent, CodecContext context) {
        Preconditions.checkNotNull((Object)intent, (Object)"Single Point to Multi Point intent cannot be null");
        JsonCodec connectivityIntentCodec = context.codec(ConnectivityIntent.class);
        ObjectNode result = connectivityIntentCodec.encode((Object)intent, context);
        JsonCodec connectPointCodec = context.codec(ConnectPoint.class);
        ObjectNode ingress = connectPointCodec.encode((Object)intent.ingressPoint(), context);
        ObjectNode result2 = context.mapper().createObjectNode();
        ArrayNode jsonconnectPoints = result2.putArray(CP_POINTS);
        if (intent.egressPoints() != null) {
            for (ConnectPoint cp : intent.egressPoints()) {
                jsonconnectPoints.add((JsonNode)connectPointCodec.encode((Object)cp, context));
            }
            result.set(EGRESS_POINT, (JsonNode)jsonconnectPoints);
        }
        result.set(INGRESS_POINT, (JsonNode)ingress);
        return result;
    }

    public SinglePointToMultiPointIntent decode(ObjectNode json, CodecContext context) {
        SinglePointToMultiPointIntent.Builder builder = SinglePointToMultiPointIntent.builder();
        IntentCodec.intentAttributes(json, context, (Intent.Builder)builder);
        ConnectivityIntentCodec.intentAttributes(json, context, (ConnectivityIntent.Builder)builder);
        ObjectNode ingressJson = (ObjectNode)Tools.nullIsIllegal((Object)SinglePointToMultiPointIntentCodec.get((ObjectNode)json, (String)INGRESS_POINT), (String)"ingressPoint member is required in Intent");
        ConnectPoint ingress = (ConnectPoint)context.codec(ConnectPoint.class).decode(ingressJson, context);
        builder.ingressPoint(ingress);
        ObjectNode egressJson = (ObjectNode)Tools.nullIsIllegal((Object)SinglePointToMultiPointIntentCodec.get((ObjectNode)json, (String)EGRESS_POINT), (String)"egressPoint member is required in Intent");
        if (egressJson != null) {
            JsonCodec connectPointCodec = context.codec(ConnectPoint.class);
            JsonNode connectPointsJson = SinglePointToMultiPointIntentCodec.get((ObjectNode)json, (String)EGRESS_POINT).get(CP_POINTS);
            HashSet<Object> egressCp = new HashSet<Object>();
            if (connectPointsJson != null) {
                for (int i = 0; i < connectPointsJson.size(); ++i) {
                    egressCp.add(connectPointCodec.decode(SinglePointToMultiPointIntentCodec.get((JsonNode)connectPointsJson, (int)i), context));
                }
                builder.egressPoints(egressCp);
            }
        }
        return builder.build();
    }
}

