/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.routing.Route;

public class RouteCodec
extends JsonCodec<Route> {
    private static final String SOURCE = "source";
    private static final String PREFIX = "prefix";
    private static final String NEXT_HOP = "nextHop";

    public ObjectNode encode(Route route, CodecContext context) {
        Preconditions.checkNotNull((Object)route);
        ObjectNode root = context.mapper().createObjectNode().put(SOURCE, route.source().toString()).put(PREFIX, route.prefix().toString()).put(NEXT_HOP, route.nextHop().toString());
        return root;
    }

    public Route decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        IpPrefix prefix = IpPrefix.valueOf((String)json.path(PREFIX).asText());
        IpAddress nextHop = IpAddress.valueOf((String)json.path(NEXT_HOP).asText());
        Route route = new Route(Route.Source.STATIC, prefix, nextHop);
        return route;
    }
}

