/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.onlab.util.Tools;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;

public final class RoleInfoCodec
extends JsonCodec<RoleInfo> {
    private static final String MASTER = "master";
    private static final String BACKUPS = "backups";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in RoleInfo";

    public ObjectNode encode(RoleInfo roleInfo, CodecContext context) {
        Preconditions.checkNotNull((Object)roleInfo, (Object)"RoleInfo cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        if (roleInfo.master() != null) {
            result.put(MASTER, (String)roleInfo.master().id());
        }
        ArrayNode backups = context.mapper().createArrayNode();
        roleInfo.backups().forEach(backup -> backups.add((String)backup.id()));
        if (!roleInfo.backups().isEmpty()) {
            result.set(BACKUPS, (JsonNode)backups);
        }
        return result;
    }

    public RoleInfo decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        NodeId nodeId = json.get(MASTER) == null ? null : NodeId.nodeId((String)json.get(MASTER).asText());
        ArrayList backups = new ArrayList();
        ArrayNode backupsJson = (ArrayNode)Tools.nullIsIllegal((Object)json.get(BACKUPS), (String)"backups member is required in RoleInfo");
        IntStream.range(0, backupsJson.size()).forEach(i -> {
            JsonNode backupJson = (JsonNode)Tools.nullIsIllegal((Object)backupsJson.get(i), (String)"Backup node id cannot be null");
            backups.add(NodeId.nodeId((String)backupJson.asText()));
        });
        return new RoleInfo(nodeId, backups);
    }
}

