/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.IntStream;
import org.onlab.util.Tools;
import org.onosproject.cluster.NodeId;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.impl.AnnotatedCodec;
import org.onosproject.net.Annotations;
import org.onosproject.net.region.DefaultRegion;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;

public class RegionCodec
extends AnnotatedCodec<Region> {
    private static final String REGION_ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String MASTERS = "masters";
    private static final String NODE_ID = "nodeId";
    private static final String NULL_REGION_MSG = "Region cannot be null";
    private static final String MISSING_MEMBER_MSG = " member is required in Region";
    private static final BiMap<String, Region.Type> REGION_TYPE_MAP = HashBiMap.create();

    public ObjectNode encode(Region region, CodecContext context) {
        Preconditions.checkNotNull((Object)region, (Object)NULL_REGION_MSG);
        ObjectNode result = context.mapper().createObjectNode().put(REGION_ID, region.id().toString()).put(NAME, region.name()).put(TYPE, region.type().toString());
        ArrayNode masters = context.mapper().createArrayNode();
        region.masters().forEach(sets -> {
            ArrayNode setsJson = context.mapper().createArrayNode();
            sets.forEach(nodeId -> setsJson.add(nodeId.toString()));
            masters.add((JsonNode)setsJson);
        });
        result.set(MASTERS, (JsonNode)masters);
        return this.annotate(result, region, context);
    }

    public Region decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        ArrayList masters = new ArrayList();
        JsonNode mastersJson = json.get(MASTERS);
        Preconditions.checkNotNull((Object)mastersJson);
        IntStream.range(0, mastersJson.size()).forEach(i -> {
            JsonNode setsJson = mastersJson.get(i);
            HashSet nodeIds = Sets.newHashSet();
            if (setsJson != null && setsJson.isArray()) {
                HashSet localNodeIds = Sets.newHashSet();
                IntStream.range(0, setsJson.size()).forEach(j -> {
                    JsonNode nodeIdJson = setsJson.get(j);
                    localNodeIds.add(this.decodeNodeId(nodeIdJson));
                });
                nodeIds.addAll(localNodeIds);
            }
            masters.add(nodeIds);
        });
        RegionId regionId = RegionId.regionId((String)this.extractMember(REGION_ID, json));
        String name = this.extractMember(NAME, json);
        Region.Type type = (Region.Type)REGION_TYPE_MAP.get((Object)this.extractMember(TYPE, json));
        Annotations annots = this.extractAnnotations(json, context);
        return new DefaultRegion(regionId, name, type, annots, masters);
    }

    private String extractMember(String key, ObjectNode json) {
        return ((JsonNode)Tools.nullIsIllegal((Object)json.get(key), (String)(key + MISSING_MEMBER_MSG))).asText();
    }

    private NodeId decodeNodeId(JsonNode json) {
        return NodeId.nodeId((String)((JsonNode)Tools.nullIsIllegal((Object)json, (String)"nodeId member is required in Region")).asText());
    }

    static {
        for (Region.Type t : Region.Type.values()) {
            REGION_TYPE_MAP.put((Object)t.name(), (Object)t);
        }
    }
}

