/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.ChassisId;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.impl.AnnotatedCodec;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;

public final class PortCodec
extends AnnotatedCodec<Port> {
    private static final String ELEMENT = "element";
    private static final String PORT_NAME = "port";
    private static final String IS_ENABLED = "isEnabled";
    private static final String TYPE = "type";
    private static final String PORT_SPEED = "portSpeed";
    private static final String PORT_NAME_LOCAL = "local";

    public ObjectNode encode(Port port, CodecContext context) {
        Preconditions.checkNotNull((Object)port, (Object)"Port cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(ELEMENT, port.element().id().toString()).put(PORT_NAME, this.portName(port.number())).put(IS_ENABLED, port.isEnabled()).put(TYPE, port.type().toString().toLowerCase()).put(PORT_SPEED, port.portSpeed());
        return this.annotate(result, port, context);
    }

    private String portName(PortNumber port) {
        return port.equals((Object)PortNumber.LOCAL) ? PORT_NAME_LOCAL : port.toString();
    }

    private static PortNumber portNumber(String portName) {
        if (portName.equalsIgnoreCase(PORT_NAME_LOCAL)) {
            return PortNumber.LOCAL;
        }
        return PortNumber.portNumber((String)portName);
    }

    public Port decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        DeviceId did = DeviceId.deviceId((String)json.get(ELEMENT).asText());
        DummyDevice device = new DummyDevice(did);
        PortNumber number = PortCodec.portNumber(json.get(PORT_NAME).asText());
        boolean isEnabled = json.get(IS_ENABLED).asBoolean();
        Port.Type type = Port.Type.valueOf((String)json.get(TYPE).asText().toUpperCase());
        long portSpeed = json.get(PORT_SPEED).asLong();
        Annotations annotations = this.extractAnnotations(json, context);
        return new DefaultPort((Element)device, number, isEnabled, type, portSpeed, new Annotations[]{annotations});
    }

    private static final class DummyDevice
    extends DefaultDevice {
        public DummyDevice(DeviceId did) {
            super(new ProviderId(did.uri().getScheme(), "PortCodec"), did, Device.Type.SWITCH, "dummy", "0", "0", "0", new ChassisId(), new Annotations[]{DefaultAnnotations.EMPTY});
        }
    }
}

