/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.ConnectivityIntentCodec;
import org.onosproject.codec.impl.IntentCodec;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.PointToPointIntent;

public final class PointToPointIntentCodec
extends JsonCodec<PointToPointIntent> {
    private static final String INGRESS_POINT = "ingressPoint";
    private static final String EGRESS_POINT = "egressPoint";

    public ObjectNode encode(PointToPointIntent intent, CodecContext context) {
        Preconditions.checkNotNull((Object)intent, (Object)"Point to point intent cannot be null");
        JsonCodec connectivityIntentCodec = context.codec(ConnectivityIntent.class);
        ObjectNode result = connectivityIntentCodec.encode((Object)intent, context);
        JsonCodec connectPointCodec = context.codec(ConnectPoint.class);
        ObjectNode ingress = connectPointCodec.encode((Object)intent.ingressPoint(), context);
        ObjectNode egress = connectPointCodec.encode((Object)intent.egressPoint(), context);
        result.set(INGRESS_POINT, (JsonNode)ingress);
        result.set(EGRESS_POINT, (JsonNode)egress);
        return result;
    }

    public PointToPointIntent decode(ObjectNode json, CodecContext context) {
        PointToPointIntent.Builder builder = PointToPointIntent.builder();
        IntentCodec.intentAttributes(json, context, (Intent.Builder)builder);
        ConnectivityIntentCodec.intentAttributes(json, context, (ConnectivityIntent.Builder)builder);
        ObjectNode ingressJson = (ObjectNode)Tools.nullIsIllegal((Object)PointToPointIntentCodec.get((ObjectNode)json, (String)INGRESS_POINT), (String)"ingressPoint member is required in Intent");
        ConnectPoint ingress = (ConnectPoint)context.codec(ConnectPoint.class).decode(ingressJson, context);
        builder.ingressPoint(ingress);
        ObjectNode egressJson = (ObjectNode)Tools.nullIsIllegal((Object)PointToPointIntentCodec.get((ObjectNode)json, (String)EGRESS_POINT), (String)"egressPoint member is required in Intent");
        ConnectPoint egress = (ConnectPoint)context.codec(ConnectPoint.class).decode(egressJson, context);
        builder.egressPoint(egress);
        return builder.build();
    }
}

