/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.AnnotatedCodec;
import org.onosproject.net.Link;
import org.onosproject.net.Path;

public final class PathCodec
extends AnnotatedCodec<Path> {
    public ObjectNode encode(Path path, CodecContext context) {
        Preconditions.checkNotNull((Object)path, (Object)"Path cannot be null");
        JsonCodec codec = context.codec(Link.class);
        ObjectNode result = context.mapper().createObjectNode().put("cost", path.cost());
        ArrayNode jsonLinks = result.putArray("links");
        for (Link link : path.links()) {
            jsonLinks.add((JsonNode)codec.encode((Object)link, context));
        }
        return this.annotate(result, path, context);
    }
}

