/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.onlab.util.Tools;
import org.onosproject.cluster.NodeId;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.packet.DefaultPacketRequest;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketRequest;

public class PacketRequestCodec
extends JsonCodec<PacketRequest> {
    static final String TRAFFIC_SELECTOR = "selector";
    static final String PRIORITY = "priority";
    static final String APP_ID = "appId";
    static final String NODE_ID = "nodeId";
    static final String DEVICE_ID = "deviceId";
    private static final String NULL_OBJECT_MSG = "PacketRequest cannot be null";
    private static final String MISSING_MEMBER_MSG = " member is required in PacketRequest";
    public static final String REST_APP_ID = "org.onosproject.rest";

    public ObjectNode encode(PacketRequest packetRequest, CodecContext context) {
        Preconditions.checkNotNull((Object)packetRequest, (Object)NULL_OBJECT_MSG);
        JsonCodec trafficSelectorCodec = context.codec(TrafficSelector.class);
        ObjectNode result = context.mapper().createObjectNode().put(NODE_ID, packetRequest.nodeId().toString()).put(PRIORITY, packetRequest.priority().name()).put(APP_ID, packetRequest.appId().toString());
        if (packetRequest.deviceId().isPresent()) {
            result.put(DEVICE_ID, ((DeviceId)packetRequest.deviceId().get()).toString());
        }
        result.set(TRAFFIC_SELECTOR, (JsonNode)trafficSelectorCodec.encode((Object)packetRequest.selector(), context));
        return result;
    }

    public PacketRequest decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonCodec trafficSelectorCodec = context.codec(TrafficSelector.class);
        TrafficSelector trafficSelector = (TrafficSelector)trafficSelectorCodec.decode(PacketRequestCodec.get((ObjectNode)json, (String)TRAFFIC_SELECTOR), context);
        NodeId nodeId = NodeId.nodeId((String)this.extractMember(NODE_ID, json));
        PacketPriority priority = PacketPriority.valueOf((String)this.extractMember(PRIORITY, json));
        CoreService coreService = (CoreService)context.getService(CoreService.class);
        ApplicationId appId = coreService.registerApplication(REST_APP_ID);
        DeviceId deviceId = null;
        JsonNode node = json.get(DEVICE_ID);
        if (node != null) {
            deviceId = DeviceId.deviceId((String)node.asText());
        }
        return new DefaultPacketRequest(trafficSelector, priority, appId, nodeId, Optional.ofNullable(deviceId));
    }

    private String extractMember(String key, ObjectNode json) {
        return ((JsonNode)Tools.nullIsIllegal((Object)json.get(key), (String)(key + MISSING_MEMBER_MSG))).asText();
    }
}

