/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.flowobjective.Objective;

public class ObjectiveCodecHelper {
    private static final String ID = "id";
    private static final String APP_ID = "appId";
    private static final String OPERATION = "operation";
    private static final String PERMANENT = "isPermanent";
    private static final String PRIORITY = "priority";
    private static final String TIMEOUT = "timeout";
    public static final String REST_APP_ID = "org.onosproject.rest";

    public ObjectNode encode(Objective objective, CodecContext context) {
        Preconditions.checkNotNull((Object)objective, (Object)"Objective cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(ID, objective.id()).put(OPERATION, objective.op().toString()).put(PERMANENT, String.valueOf(objective.permanent())).put(PRIORITY, objective.priority()).put(TIMEOUT, objective.timeout());
        if (objective.appId() != null) {
            result.put(APP_ID, objective.appId().toString());
        }
        return result;
    }

    public Objective.Builder decode(ObjectNode json, Objective.Builder builder, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        boolean permanent = false;
        if (json.get(PERMANENT) != null) {
            permanent = json.get(PERMANENT).asBoolean();
        }
        int timeoutInt = 0;
        if (json.get(TIMEOUT) != null) {
            timeoutInt = json.get(TIMEOUT).asInt();
        }
        int priorityInt = 0;
        if (json.get(PRIORITY) != null) {
            priorityInt = json.get(PRIORITY).asInt();
        }
        if (permanent) {
            builder.makePermanent().withPriority(priorityInt);
        } else {
            builder.makeTemporary(timeoutInt).withPriority(priorityInt);
        }
        return builder;
    }
}

