/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.stream.IntStream;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.ObjectiveCodecHelper;
import org.onosproject.core.CoreService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NextObjectiveCodec
extends JsonCodec<NextObjective> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ID = "id";
    private static final String APP_ID = "appId";
    private static final String TYPE = "type";
    private static final String OPERATION = "operation";
    private static final String TREATMENTS = "treatments";
    private static final String META = "meta";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in NextObjective";
    private static final String NOT_NULL_MESSAGE = "NextObjective cannot be null";
    public static final String REST_APP_ID = "org.onosproject.rest";

    public ObjectNode encode(NextObjective nextObjective, CodecContext context) {
        Preconditions.checkNotNull((Object)nextObjective, (Object)NOT_NULL_MESSAGE);
        JsonCodec trafficTreatmentCodec = context.codec(TrafficTreatment.class);
        JsonCodec trafficSelectorCodec = context.codec(TrafficSelector.class);
        ObjectiveCodecHelper och = new ObjectiveCodecHelper();
        ObjectNode result = och.encode((Objective)nextObjective, context);
        result.put(ID, nextObjective.id());
        result.put(TYPE, nextObjective.type().toString());
        result.put(OPERATION, nextObjective.op().toString());
        ArrayNode treatments = context.mapper().createArrayNode();
        nextObjective.next().forEach(t -> {
            ObjectNode treatmentJson = trafficTreatmentCodec.encode(t, context);
            treatments.add((JsonNode)treatmentJson);
        });
        result.set(TREATMENTS, (JsonNode)treatments);
        if (nextObjective.meta() != null) {
            ObjectNode trafficSelectorNode = trafficSelectorCodec.encode((Object)nextObjective.meta(), context);
            result.set(META, (JsonNode)trafficSelectorNode);
        }
        return result;
    }

    public NextObjective decode(ObjectNode json, CodecContext context) {
        NextObjective nextObjective;
        String opStr;
        JsonNode metaJson;
        String typeStr;
        if (json == null || !json.isObject()) {
            return null;
        }
        CoreService coreService = (CoreService)context.getService(CoreService.class);
        JsonCodec trafficSelectorCodec = context.codec(TrafficSelector.class);
        JsonCodec trafficTreatmentCodec = context.codec(TrafficTreatment.class);
        ObjectiveCodecHelper och = new ObjectiveCodecHelper();
        DefaultNextObjective.Builder baseBuilder = DefaultNextObjective.builder();
        DefaultNextObjective.Builder builder = (DefaultNextObjective.Builder)och.decode(json, (Objective.Builder)baseBuilder, context);
        JsonNode idJson = json.get(ID);
        Preconditions.checkNotNull((Object)idJson);
        builder.withId(idJson.asInt());
        JsonNode appIdJson = json.get(APP_ID);
        String appId = appIdJson != null ? appIdJson.asText() : REST_APP_ID;
        builder.fromApp(coreService.registerApplication(appId));
        switch (typeStr = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in NextObjective")).asText()) {
            case "HASHED": {
                builder.withType(NextObjective.Type.HASHED);
                break;
            }
            case "BROADCAST": {
                builder.withType(NextObjective.Type.BROADCAST);
                break;
            }
            case "FAILOVER": {
                builder.withType(NextObjective.Type.FAILOVER);
                break;
            }
            case "SIMPLE": {
                builder.withType(NextObjective.Type.SIMPLE);
                break;
            }
            default: {
                throw new IllegalArgumentException("The requested type " + typeStr + " is not defined for FilteringObjective.");
            }
        }
        JsonNode treatmentsJson = json.get(TREATMENTS);
        Preconditions.checkNotNull((Object)treatmentsJson);
        if (treatmentsJson != null) {
            IntStream.range(0, treatmentsJson.size()).forEach(i -> {
                ObjectNode treatmentJson = NextObjectiveCodec.get((JsonNode)treatmentsJson, (int)i);
                builder.addTreatment((TrafficTreatment)trafficTreatmentCodec.decode(treatmentJson, context));
            });
        }
        if ((metaJson = json.get(META)) != null) {
            TrafficSelector trafficSelector = (TrafficSelector)trafficSelectorCodec.decode((ObjectNode)metaJson, context);
            builder.withMeta(trafficSelector);
        }
        switch (opStr = ((JsonNode)Tools.nullIsIllegal((Object)json.get(OPERATION), (String)"operation member is required in NextObjective")).asText()) {
            case "ADD": {
                nextObjective = builder.add();
                break;
            }
            case "REMOVE": {
                nextObjective = builder.remove();
                break;
            }
            default: {
                throw new IllegalArgumentException("The requested operation " + opStr + " is not defined for FilteringObjective.");
            }
        }
        return nextObjective;
    }
}

