/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;

public class MetricCodec
extends JsonCodec<Metric> {
    private static final String COUNTER = "counter";
    private static final String GAUGE = "gauge";
    private static final String VALUE = "value";
    private static final String METER = "meter";
    private static final String MEAN_RATE = "mean_rate";
    private static final String ONE_MIN_RATE = "1_min_rate";
    private static final String FIVE_MIN_RATE = "5_min_rate";
    private static final String FIFT_MIN_RATE = "15_min_rate";
    private static final String HISTOGRAM = "histogram";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String MEAN = "mean";
    private static final String STDDEV = "stddev";
    private static final String TIMER = "timer";

    public ObjectNode encode(Metric metric, CodecContext context) {
        Preconditions.checkNotNull((Object)metric, (Object)"Metric cannot be null");
        ObjectNode objectNode = context.mapper().createObjectNode();
        ObjectNode dataNode = context.mapper().createObjectNode();
        if (metric instanceof Counter) {
            dataNode.put(COUNTER, ((Counter)metric).getCount());
            objectNode.set(COUNTER, (JsonNode)dataNode);
        } else if (metric instanceof Gauge) {
            objectNode.put(VALUE, ((Gauge)metric).getValue().toString());
            objectNode.set(GAUGE, (JsonNode)dataNode);
        } else if (metric instanceof Meter) {
            dataNode.put(COUNTER, ((Meter)metric).getCount());
            dataNode.put(MEAN_RATE, ((Meter)metric).getMeanRate());
            dataNode.put(ONE_MIN_RATE, ((Meter)metric).getOneMinuteRate());
            dataNode.put(FIVE_MIN_RATE, ((Meter)metric).getFiveMinuteRate());
            dataNode.put(FIFT_MIN_RATE, ((Meter)metric).getFifteenMinuteRate());
            objectNode.set(METER, (JsonNode)dataNode);
        } else if (metric instanceof Histogram) {
            dataNode.put(COUNTER, ((Histogram)metric).getCount());
            dataNode.put(MEAN, ((Histogram)metric).getSnapshot().getMean());
            dataNode.put(MIN, ((Histogram)metric).getSnapshot().getMin());
            dataNode.put(MAX, ((Histogram)metric).getSnapshot().getMax());
            dataNode.put(STDDEV, ((Histogram)metric).getSnapshot().getStdDev());
            objectNode.set(HISTOGRAM, (JsonNode)dataNode);
        } else if (metric instanceof Timer) {
            dataNode.put(COUNTER, ((Timer)metric).getCount());
            dataNode.put(MEAN_RATE, ((Timer)metric).getMeanRate());
            dataNode.put(ONE_MIN_RATE, ((Timer)metric).getOneMinuteRate());
            dataNode.put(FIVE_MIN_RATE, ((Timer)metric).getFiveMinuteRate());
            dataNode.put(FIFT_MIN_RATE, ((Timer)metric).getFifteenMinuteRate());
            dataNode.put(MEAN, this.nanoToMs(((Timer)metric).getSnapshot().getMean()));
            dataNode.put(MIN, this.nanoToMs(((Timer)metric).getSnapshot().getMin()));
            dataNode.put(MAX, this.nanoToMs(((Timer)metric).getSnapshot().getMax()));
            dataNode.put(STDDEV, this.nanoToMs(((Timer)metric).getSnapshot().getStdDev()));
            objectNode.set(TIMER, (JsonNode)dataNode);
        }
        return objectNode;
    }

    private double nanoToMs(double nano) {
        return TimeUnit.MILLISECONDS.convert((long)nano, TimeUnit.NANOSECONDS);
    }
}

