/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultMeterRequest;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MeterRequestCodec
extends JsonCodec<MeterRequest> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DEVICE_ID = "deviceId";
    private static final String UNIT = "unit";
    private static final String BANDS = "bands";
    public static final String REST_APP_ID = "org.onosproject.rest";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in MeterRequest";

    public MeterRequest decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonCodec meterBandCodec = context.codec(Band.class);
        CoreService coreService = (CoreService)context.getService(CoreService.class);
        DeviceId deviceId = DeviceId.deviceId((String)((JsonNode)Tools.nullIsIllegal((Object)json.get(DEVICE_ID), (String)"deviceId member is required in MeterRequest")).asText());
        ApplicationId appId = coreService.registerApplication(REST_APP_ID);
        boolean burst = false;
        JsonNode burstJson = json.get("burst");
        if (burstJson != null) {
            burst = burstJson.asBoolean();
        }
        String unit = ((JsonNode)Tools.nullIsIllegal((Object)json.get(UNIT), (String)"unit member is required in MeterRequest")).asText();
        Meter.Unit meterUnit = null;
        switch (unit) {
            case "KB_PER_SEC": {
                meterUnit = Meter.Unit.KB_PER_SEC;
                break;
            }
            case "PKTS_PER_SEC": {
                meterUnit = Meter.Unit.PKTS_PER_SEC;
                break;
            }
            default: {
                Tools.nullIsIllegal((Object)meterUnit, (String)("The requested unit " + unit + " is not defined for meter."));
            }
        }
        ArrayList bandList = new ArrayList();
        JsonNode bandsJson = json.get(BANDS);
        Preconditions.checkNotNull((Object)bandsJson);
        if (bandsJson != null) {
            IntStream.range(0, bandsJson.size()).forEach(i -> {
                ObjectNode bandJson = MeterRequestCodec.get((JsonNode)bandsJson, (int)i);
                bandList.add(meterBandCodec.decode(bandJson, context));
            });
        }
        MeterRequest meterRequest = burst ? DefaultMeterRequest.builder().fromApp(appId).forDevice(deviceId).withUnit(meterUnit).withBands(bandList).burst().add() : DefaultMeterRequest.builder().fromApp(appId).forDevice(deviceId).withUnit(meterUnit).withBands(bandList).add();
        return meterRequest;
    }
}

