/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.Meter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MeterCodec
extends JsonCodec<Meter> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ID = "id";
    private static final String STATE = "state";
    private static final String LIFE = "life";
    private static final String PACKETS = "packets";
    private static final String BYTES = "bytes";
    private static final String REFERENCE_COUNT = "referenceCount";
    private static final String APP_ID = "appId";
    private static final String BURST = "burst";
    private static final String DEVICE_ID = "deviceId";
    private static final String UNIT = "unit";
    private static final String BANDS = "bands";
    public static final String REST_APP_ID = "org.onosproject.rest";

    public ObjectNode encode(Meter meter, CodecContext context) {
        Preconditions.checkNotNull((Object)meter, (Object)"Meter cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(ID, meter.id().toString()).put(LIFE, meter.life()).put(PACKETS, meter.packetsSeen()).put(BYTES, meter.bytesSeen()).put(REFERENCE_COUNT, meter.referenceCount()).put(UNIT, meter.unit().toString()).put(BURST, meter.isBurst()).put(DEVICE_ID, meter.deviceId().toString());
        if (meter.appId() != null) {
            result.put(APP_ID, meter.appId().name());
        }
        if (meter.state() != null) {
            result.put(STATE, meter.state().toString());
        }
        ArrayNode bands = context.mapper().createArrayNode();
        meter.bands().forEach(band -> {
            ObjectNode bandJson = context.codec(Band.class).encode(band, context);
            bands.add((JsonNode)bandJson);
        });
        result.set(BANDS, (JsonNode)bands);
        return result;
    }
}

